/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.api;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.DocumentYourModModApi;
import com.aaronhowser1.dymm.api.configuration.ConfigurationManager;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import java.io.File;
import java.util.Iterator;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.registries.IForgeRegistry;

public final class ApiBindings {
    private static final L LOG = L.create("DYMM API", "Api Bindings");

    private ApiBindings() {
    }

    @Nonnull
    public static DocumentYourModModApi getMainApi() {
        return MainApiBindingHolder.API;
    }

    @Nonnull
    private static <T> T loadThroughService(@Nonnull Class<T> apiClass, @Nonnull Supplier<T> defaultObjectCreator) {
        ServiceLoader<T> loader = ServiceLoader.load(apiClass);
        Iterator<T> foundImplementations = loader.iterator();
        Object targetApi = null;
        while (foundImplementations.hasNext()) {
            T next = foundImplementations.next();
            if (targetApi == null) {
                targetApi = next;
                continue;
            }
            if (!next.getClass().getName().contains("aaronhowser1.dym.common") || targetApi.getClass().getName().contains("aaronhowser1.dym.common")) continue;
            LOG.warn("Another implementation for the API class " + apiClass.getName() + " was found, but the official one is available on the classpath");
            LOG.warn("The old implementation (" + targetApi.getClass().getName() + ") will be replaced with our own");
            targetApi = next;
        }
        if (targetApi == null) {
            LOG.bigError("No API Binding found for class " + apiClass.getName() + ": replacing with a dummy implementation!\nNote that this will cause errors later on!");
            targetApi = Objects.requireNonNull(defaultObjectCreator.get());
        }
        LOG.info("Using " + targetApi.getClass().getName() + " as binding for API class " + apiClass.getName());
        return (T)targetApi;
    }

    static /* synthetic */ Object access$000(Class x0, Supplier x1) {
        return ApiBindings.loadThroughService(x0, x1);
    }

    private static final class MainApiBindingHolder {
        private static final DocumentYourModModApi API = (DocumentYourModModApi)ApiBindings.access$000(DocumentYourModModApi.class, () -> new DocumentYourModModApi(){

            @Override
            @Nonnull
            public ConfigurationManager getConfigurationManager() {
                return new ConfigurationManager(){

                    @Override
                    @Nonnull
                    public Configuration getVersionedConfigurationFor(@Nonnull String name, @Nonnull String version) {
                        return new Configuration(new File(name), version);
                    }

                    @Override
                    @Nonnull
                    public Configuration getConfigurationFor(@Nonnull String name) {
                        return this.getVersionedConfigurationFor(name, "0");
                    }
                };
            }

            @Override
            @Nullable
            public GlobalLoadingState getCurrentLoadingState() {
                return null;
            }

            @Override
            @Nonnull
            public IForgeRegistry<DocumentationEntry> getDocumentationRegistry() {
                throw new IllegalStateException("Registry wasn't created yet");
            }
        });

        private MainApiBindingHolder() {
        }
    }
}

