/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.client;

import com.aaronhowser1.dymm.api.ApiBindings;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="dymm", value={Side.CLIENT})
public final class MainMenuDocumentedTargetsHandler {
    private static boolean prevShallBrand = false;

    @SubscribeEvent
    public static void onOpenGuiEvent(@Nonnull GuiOpenEvent event) {
        if (!(event.getGui() instanceof GuiMainMenu)) {
            return;
        }
        Configuration configuration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_main");
        boolean shallBrand = configuration.getBoolean("branding_time", "foolery", false, "Mods loaded... mods active... but how many are documented?\nAdds the amount of documented mods to the mod count in the bottom left of the main menu.\nExample: \"15 mods loaded, 15 mods active, 10 mods documented\"");
        if (prevShallBrand != shallBrand) {
            prevShallBrand = shallBrand;
            ArrayList<String> brandList = new ArrayList<String>(LazyConstants.PREVIOUS_BRAND_LIST);
            ArrayList<String> brandListNoMc = new ArrayList<String>(LazyConstants.PREVIOUS_BRAND_NO_MC_LIST);
            if (shallBrand) {
                int targetIndex = -1;
                for (int i = 0; i < brandList.size(); ++i) {
                    if (!((String)brandList.get(i)).contains("active") || !((String)brandList.get(i)).contains("mod")) continue;
                    targetIndex = i;
                    break;
                }
                if (targetIndex == -1) {
                    return;
                }
                String s = LazyConstants.DOCUMENTED_TARGETS_COUNT != 1 ? "s" : "";
                brandList.set(targetIndex, (String)brandList.get(targetIndex) + String.format(", %d mod%s documented", LazyConstants.DOCUMENTED_TARGETS_COUNT, s));
                brandListNoMc.set(targetIndex - 1, (String)brandListNoMc.get(targetIndex - 1) + String.format(", %d mod%s documented", LazyConstants.DOCUMENTED_TARGETS_COUNT, s));
            }
            try {
                LazyConstants.BRAND.set(FMLCommonHandler.instance(), brandList);
                LazyConstants.BRAND_NO_MC.set(FMLCommonHandler.instance(), brandListNoMc);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
    }

    private static final class LazyConstants {
        private static final int DOCUMENTED_TARGETS_COUNT;
        private static final Field BRAND;
        private static final Field BRAND_NO_MC;
        private static final List<String> PREVIOUS_BRAND_LIST;
        private static final List<String> PREVIOUS_BRAND_NO_MC_LIST;

        private LazyConstants() {
        }

        static {
            FMLCommonHandler.instance().computeBranding();
            DOCUMENTED_TARGETS_COUNT = (int)ApiBindings.getMainApi().getDocumentationRegistry().getValuesCollection().stream().map(IForgeRegistryEntry::getRegistryName).peek(Objects::requireNonNull).map(ResourceLocation::func_110624_b).distinct().count();
            try {
                Class<?> handler = FMLCommonHandler.instance().getClass();
                BRAND = handler.getDeclaredField("brandings");
                BRAND_NO_MC = handler.getDeclaredField("brandingsNoMC");
                BRAND.setAccessible(true);
                BRAND_NO_MC.setAccessible(true);
                PREVIOUS_BRAND_LIST = new ArrayList<String>((Collection)BRAND.get(FMLCommonHandler.instance()));
                PREVIOUS_BRAND_NO_MC_LIST = new ArrayList<String>((Collection)BRAND_NO_MC.get(FMLCommonHandler.instance()));
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to reflectively get the handler class!", e);
            }
        }
    }
}

