/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.configuration;

import com.aaronhowser1.dymm.api.ApiBindings;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;

public final class MainConfigurationHandler {
    private MainConfigurationHandler() {
    }

    public static void initializeMainModConfiguration() {
        MainConfigurationHandler.initializeMainConfiguration();
        MainConfigurationHandler.initializeModsConfiguration();
    }

    private static void initializeMainConfiguration() {
        Configuration configuration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_main");
        ConfigCategory debug = configuration.getCategory("debug");
        debug.setComment("Set of options useful for developers: you generally want these to be set to false");
        configuration.get("debug", "target_documented", false, "Shows in the game console which targets have been documented");
        configuration.get("debug", "missing_entries", false, "Automatically scans the targets and displays in the console which items haven't been documented yet. Only works with targets that have at least one documented entry");
        configuration.get("debug", "target_entries", false, "Shows on the target tooltip which entries are responsible for its documentation");
        ConfigCategory foolery = configuration.getCategory("foolery");
        foolery.setComment("Some random features that aren't part of the mod, but may be fun to enable and play around with nonetheless");
        configuration.get("foolery", "branding_time", false, "Mods loaded... mods active... but how many are documented?\nAdds the amount of documented mods to the mod count in the bottom left of the main menu.\nExample: \"15 mods loaded, 15 mods active, 10 mods documented\"");
        ConfigCategory performance = configuration.getCategory("performance");
        performance.setComment("Allows you to configure some mod behavior, allowing you to prioritize speed over efficiency or vice versa");
        configuration.get("performance", "ram_saving", false, "Makes the mod run in RAM-light mode, making it allocate as few resources as possible.\nWARNING! This WILL exponentially decrease performance up to 70%! Use this option if you REALLY need to spare as much RAM as possible!\nIn most cases this mod can automatically regulate itself, so turn this on ONLY if you've already tried everything! Do NOT come to us for huge slowdowns").setRequiresMcRestart(true);
        configuration.save();
    }

    private static void initializeModsConfiguration() {
        Configuration configuration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_targets");
        ConfigCategory targets = configuration.getCategory("targets");
        targets.setComment("Set here which targets should be enabled or not.\nNote that not all targets present here may also have entries in game.\nNOTE: Certain targets may require additional configuration");
        Loader.instance().getModList().forEach(it -> configuration.get("targets", it.getModId(), true, it.getName()));
        configuration.save();
    }
}

