/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.loading;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.loading.DocumentationLoader;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.common.loading.LoaderRegistry;
import com.aaronhowser1.dymm.common.loading.LoadingHandler;
import com.aaronhowser1.dymm.common.loading.LoadingState;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.AssertNotNullExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KClass;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.id.NameSpacedString;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Context;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.ContextKey;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Processor;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class DocumentationLoadingProcessor
implements Processor<JsonObject> {
    private static final L LOG = L.create("Document Your Mod Mod", "Documentation Processor");
    private static final int FLAG_FACTORIES = 1;
    private static final int FLAG_METADATA = 2;
    private static final int FLAG_DOCUMENTATION = 4;
    private static final String FACTORY_CONDITION = "condition";
    private static final String FACTORY_TARGET = "target";
    private static final String KEY_LOADER = "loader";
    private static final Map<String, Class<?>> NAME_TO_INTERFACE = new HashMap();
    private static final Map<String, ContextKey<?>> NAME_TO_CONTEXT_KEY = new HashMap();
    private final TriFunction<JsonObject, NameSpacedString, Context, Unit> processorFunction;

    private DocumentationLoadingProcessor(int flag) {
        if (flag == 1) {
            this.processorFunction = this::processFactories;
        } else if (flag == 2) {
            this.processorFunction = this::processMetadata;
        } else if (flag == 4) {
            this.processorFunction = this::processDocumentation;
        } else {
            throw new IllegalArgumentException("Flag " + flag + " was unrecognized");
        }
    }

    @Nonnull
    static DocumentationLoadingProcessor withFlag(int flag) {
        return new DocumentationLoadingProcessor(flag);
    }

    @Nonnull
    static <T> Map<ResourceLocation, T> get(@Nonnull Context globalContext, @Nonnull String marker) {
        ContextKey<?> contextKey = NAME_TO_CONTEXT_KEY.get(marker);
        return (Map)((Object)AssertNotNullExpression.create(globalContext.get(contextKey)).invoke());
    }

    @Override
    @Nonnull
    public Unit process(@Nonnull JsonObject content, @Nonnull NameSpacedString identifier, @Nonnull Nullable<Context> globalContext, @Nonnull Nullable<Context> phaseContext) {
        return this.processorFunction.invoke(content, identifier, (Context)((Object)AssertNotNullExpression.create(globalContext).invoke()));
    }

    @Nonnull
    private Unit processFactories(@Nonnull JsonObject content, @Nonnull NameSpacedString identifier, @Nonnull Context globalContext) {
        content.entrySet().forEach(it -> {
            String name = (String)it.getKey();
            LOG.debug("Attempting to read data from JsonObject for factory type '" + name + "'");
            Class<?> factoryClass = NAME_TO_INTERFACE.get(name);
            if (factoryClass == null) {
                LOG.warn("'" + name + "' isn't a type of factory that is recognized by the system");
                return;
            }
            JsonObject object = ((JsonElement)it.getValue()).getAsJsonObject();
            object.entrySet().forEach(factoryEntry -> {
                Object factoryAny;
                ResourceLocation id = this.constructFactoryName(identifier, (String)factoryEntry.getKey());
                if (!((JsonElement)factoryEntry.getValue()).isJsonPrimitive() || !((JsonElement)factoryEntry.getValue()).getAsJsonPrimitive().isString()) {
                    throw new JsonSyntaxException("The entry for a factory must be composed of a string key and a string value, referring to the target class");
                }
                try {
                    factoryAny = Class.forName(((JsonElement)factoryEntry.getValue()).getAsString()).getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (ReflectiveOperationException e) {
                    throw new RuntimeException(e);
                }
                Object factory = factoryClass.cast(factoryAny);
                Map map = (Map)globalContext.computeIfAbsent(Objects.requireNonNull(NAME_TO_CONTEXT_KEY.get(name), name + " does not have a context key"), key -> new HashMap());
                if (map.get(id) != null && !"dymm".equals(id.func_110624_b())) {
                    LOG.bigWarn("An attempt of overriding a previously registered factory has been identified\nNote that this attempt will not be blocked, but it may lead to errors in the future\nName of conflict: " + id, L.DumpStackBehavior.DO_NOT_DUMP);
                }
                map.put(id, factory);
            });
        });
        return Unit.UNIT;
    }

    @Nonnull
    private ResourceLocation constructFactoryName(@Nonnull NameSpacedString identifier, @Nonnull String key) {
        if (key.indexOf(58) != -1) {
            String[] parts = key.split(Pattern.quote(":"), 2);
            String providedNamespace = parts[0];
            String path = parts[1];
            if (identifier.getNameSpace().equals(providedNamespace)) {
                LOG.warn("Found additional namespace '" + providedNamespace + "' for identifier '" + identifier + "': this is unnecessary and will be stripped out");
            } else {
                LOG.warn("Attempting to register factory '" + path + "' with namespace '" + providedNamespace + "' instead of the expected '" + identifier.getNameSpace() + "': this may cause errors later on");
            }
            return new ResourceLocation(providedNamespace, path);
        }
        return new ResourceLocation(identifier.getNameSpace(), key);
    }

    @Nonnull
    private Unit processMetadata(@Nonnull JsonObject content, @Nonnull NameSpacedString identifier, @Nonnull Context globalContext) {
        String type = identifier.getPath().substring(1);
        LOG.info("Firing process metadata event of type '" + type + "' for '" + identifier + "'");
        LoaderRegistry.INSTANCE.fireEvent(content, type, identifier.getNameSpace());
        return Unit.UNIT;
    }

    @Nonnull
    private Unit processDocumentation(@Nonnull JsonObject content, @Nonnull NameSpacedString identifier, @Nonnull Context globalContext) {
        if (!this.isEnabled(identifier)) {
            LOG.info("Skipping processing of entry '" + identifier + "' because its namespace was disabled in the targets configuration");
            return Unit.UNIT;
        }
        if (!content.has(KEY_LOADER)) {
            LOG.warn("The entry '" + identifier + "' has no loader specified! This is DEPRECATED and support for it will be removed soon. Replacing with default loader");
            content.add(KEY_LOADER, (JsonElement)new JsonPrimitive("dymm:default"));
        }
        return this.processDocumentationWithLoader(content, identifier, globalContext);
    }

    private boolean isEnabled(@Nonnull NameSpacedString identifier) {
        String namespace = identifier.getNameSpace();
        ModContainer targetContainer = Loader.instance().getModList().stream().filter(it -> namespace.equals(it.getModId())).findFirst().orElseThrow(RuntimeException::new);
        Configuration targets = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_targets");
        return targets.get("targets", namespace, true, targetContainer.getName()).getBoolean();
    }

    @Nonnull
    private Unit processDocumentationWithLoader(@Nonnull JsonObject content, @Nonnull NameSpacedString identifier, @Nonnull Context globalContext) {
        DocumentationEntry entry;
        String loaderName = content.get(KEY_LOADER).getAsString();
        LOG.debug("Attempting to load '" + identifier + "' with loader name '" + loaderName + "'");
        if (loaderName.indexOf(58) == -1) {
            throw new JsonSyntaxException("For file '" + identifier + "': the loader name must be name-spaced");
        }
        DocumentationLoader loader = LoaderRegistry.INSTANCE.findLoader(new ResourceLocation(loaderName));
        if (loader == null) {
            throw new JsonParseException("For file '" + identifier + "': unable to find the specified loader '" + loaderName + "': maybe it hasn't been registered?");
        }
        this.buildStateFor(loader, identifier, globalContext);
        try {
            entry = loader.loadFromJson(content);
        }
        catch (Exception e) {
            throw new JsonParseException(e.getMessage(), (Throwable)e);
        }
        if (entry == null) {
            LOG.warn("Attempting to load documentation entry '" + identifier + "' resulted in a null entry being produced. While not an error, this is generally not advised. The registration will be skipped");
            return Unit.UNIT;
        }
        entry.setRegistryName(new ResourceLocation(identifier.getNameSpace(), identifier.getPath()));
        LoadingHandler.getRegistry().register((IForgeRegistryEntry)entry);
        return Unit.UNIT;
    }

    private void buildStateFor(@Nonnull DocumentationLoader loader, @Nonnull NameSpacedString identifier, @Nonnull Context globalContext) {
        ResourceLocation targetId = new ResourceLocation(identifier.getNameSpace(), identifier.getPath());
        LoadingState.rebuild(targetId, LOG, loader, globalContext);
    }

    static {
        NAME_TO_INTERFACE.put(FACTORY_CONDITION, ConditionFactory.class);
        NAME_TO_INTERFACE.put(FACTORY_TARGET, TargetFactory.class);
        NAME_TO_CONTEXT_KEY.put(FACTORY_CONDITION, ContextKey.invoke(FACTORY_CONDITION, KClass.get(Map.class)));
        NAME_TO_CONTEXT_KEY.put(FACTORY_TARGET, ContextKey.invoke(FACTORY_TARGET, KClass.get(Map.class)));
    }

    @FunctionalInterface
    private static interface TriFunction<A, B, C, R> {
        @Nonnull
        public R invoke(@Nonnull A var1, @Nonnull B var2, @Nonnull C var3);
    }
}

