/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.loading;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.documentation.Target;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class TargetsHandler {
    private static final L DOCUMENTED_LOG = L.create("Document Your Mod Mod", "Documented Targets");
    private static final L UNDOCUMENTED_LOG = L.create("Document Your Mod Mod", "Undocumented Targets");

    private TargetsHandler() {
    }

    public static void discoverAndLog() {
        TargetsHandler.discoverAndLogDocumented();
        TargetsHandler.discoverAndLogUndocumented();
    }

    private static void discoverAndLogDocumented() {
        Configuration configuration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_main");
        boolean shouldPrint = configuration.getBoolean("target_documented", "debug", false, "Shows in the game console which targets have been documented");
        if (!shouldPrint) {
            return;
        }
        TargetsHandler.discoverAndLogDocumented(DOCUMENTED_LOG::info);
    }

    private static void discoverAndLogDocumented(@Nonnull Consumer<String> consumer) {
        ApiBindings.getMainApi().getDocumentationRegistry().getValuesCollection().stream().map(IForgeRegistryEntry::getRegistryName).peek(Objects::requireNonNull).map(ResourceLocation::func_110624_b).distinct().map(it -> "Target '" + it + "' has been documented").forEach(consumer);
    }

    private static void discoverAndLogUndocumented() {
        Configuration configuration = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_main");
        boolean shouldUseWarn = configuration.getBoolean("missing_entries", "debug", false, "Automatically scans the targets and displays in the console which items haven't been documented yet. Only works with targets that have at least one documented entry");
        Consumer<String> logFunction = shouldUseWarn ? UNDOCUMENTED_LOG::warn : UNDOCUMENTED_LOG::debug;
        TargetsHandler.discoverAndLogUndocumented(logFunction);
    }

    private static void discoverAndLogUndocumented(@Nonnull Consumer<String> logFun) {
        UNDOCUMENTED_LOG.info("Discovering not documented targets");
        Map<ResourceLocation, DocumentationEntry> documentedTargets = TargetsHandler.findDocumentedTargets();
        Set<String> documentedNamespaces = documentedTargets.keySet().stream().map(ResourceLocation::func_110624_b).collect(Collectors.toSet());
        Map<String, List<ResourceLocation>> targetsForTargets = TargetsHandler.findAllPossibleTargetsFor();
        Map<String, List<ResourceLocation>> missingTargets = TargetsHandler.mergeAndFind(documentedNamespaces, documentedTargets, targetsForTargets);
        TargetsHandler.logMissingTargets(missingTargets, logFun);
        UNDOCUMENTED_LOG.info("Discovery complete");
        logFun.accept("Note that the list may have some elements missing, especially in case of metadata: revise in game anyway");
    }

    @Nonnull
    private static Map<ResourceLocation, DocumentationEntry> findDocumentedTargets() {
        return ApiBindings.getMainApi().getDocumentationRegistry().getValuesCollection().stream().flatMap(it -> it.getTargets().stream().map(Target::obtainTarget).map(ItemStack::func_77973_b).map(IForgeRegistryEntry.Impl::getRegistryName).map(target -> ImmutablePair.of((Object)target, (Object)it))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight, (a, b) -> a));
    }

    @Nonnull
    private static Map<String, List<ResourceLocation>> findAllPossibleTargetsFor() {
        return ForgeRegistries.ITEMS.getValuesCollection().stream().map(IForgeRegistryEntry.Impl::getRegistryName).peek(Objects::requireNonNull).map(it -> ImmutablePair.of((Object)it.func_110624_b(), (Object)it)).collect(Collectors.groupingBy(Pair::getLeft)).entrySet().stream().map(it -> ImmutablePair.of(it.getKey(), ((List)it.getValue()).stream().map(Pair::getValue).collect(Collectors.toList()))).collect(Collectors.toMap(Pair::getLeft, Pair::getRight));
    }

    @Nonnull
    private static Map<String, List<ResourceLocation>> mergeAndFind(@Nonnull Set<String> documentedNamespaces, @Nonnull Map<ResourceLocation, DocumentationEntry> documentedTargets, @Nonnull Map<String, List<ResourceLocation>> targetsForTargets) {
        return targetsForTargets.entrySet().stream().filter(it -> documentedNamespaces.contains(it.getKey())).flatMap(it -> ((List)it.getValue()).stream()).filter(it -> !documentedTargets.containsKey(it)).collect(Collectors.groupingBy(ResourceLocation::func_110624_b));
    }

    private static void logMissingTargets(@Nonnull Map<String, List<ResourceLocation>> missingTargets, @Nonnull Consumer<String> logFun) {
        TargetsHandler.logMissingTargets(missingTargets.entrySet().stream().flatMap(it -> ((List)it.getValue()).stream().map(target -> ImmutablePair.of(it.getKey(), (Object)target))).collect(Collectors.toList()), logFun);
    }

    private static void logMissingTargets(@Nonnull List<Pair<String, ResourceLocation>> missingTargets, @Nonnull Consumer<String> logFun) {
        missingTargets.stream().map(it -> "Found undocumented target '" + it.getRight() + "' for namespace '" + (String)it.getLeft() + "'").forEach(logFun);
    }
}

