/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.sort;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.annotation.Nonnull;

public final class DirectedGraph<T>
implements Iterable<T> {
    private final Map<T, SortedSet<T>> graph = new LinkedHashMap<T, SortedSet<T>>();
    private final List<T> orderedNodes = new ArrayList<T>();

    void addNode(@Nonnull T node) {
        if (this.graph.containsKey(node)) {
            return;
        }
        this.orderedNodes.add(node);
        this.graph.put(node, new TreeSet<Object>(Comparator.comparingInt(this.orderedNodes::indexOf)));
    }

    void addEdge(@Nonnull T from, @Nonnull T to) {
        this.checkNodes(from, to);
        this.graph.get(from).add(to);
    }

    @Nonnull
    Set<T> edgesFrom(@Nonnull T from) {
        if (!this.graph.containsKey(from)) {
            throw new NoSuchElementException("Missing node from graph");
        }
        return Collections.unmodifiableSortedSet(this.graph.get(from));
    }

    private void checkNodes(@Nonnull T from, @Nonnull T to) {
        if (!this.graph.containsKey(from) || !this.graph.containsKey(to)) {
            throw new NoSuchElementException("Missing nodes from graph");
        }
    }

    @Override
    @Nonnull
    public Iterator<T> iterator() {
        return this.orderedNodes.iterator();
    }

    public String toString() {
        return this.graph.toString();
    }
}

