/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.sort;

import com.aaronhowser1.dymm.api.documentation.Dependency;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.common.sort.DirectedGraph;
import com.aaronhowser1.dymm.common.sort.SortingDocumentationEntry;
import com.aaronhowser1.dymm.common.sort.TopologicalSort;
import com.aaronhowser1.dymm.common.sort.UnsatisfiedDependencyException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class DocumentationSorter {
    private final Map<ResourceLocation, DocumentationEntry> entries;

    public DocumentationSorter(@Nonnull Set<Map.Entry<ResourceLocation, DocumentationEntry>> entries) {
        this.entries = entries.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    @Nonnull
    public List<DocumentationEntry> sort() {
        DirectedGraph<DocumentationEntry> graph = new DirectedGraph<DocumentationEntry>();
        SortingDocumentationEntry beforeAll = new SortingDocumentationEntry("before_all");
        SortingDocumentationEntry afterAll = new SortingDocumentationEntry("after_all");
        graph.addNode(beforeAll);
        graph.addNode(afterAll);
        Map<String, Pair<DocumentationEntry, DocumentationEntry>> targetEntries = this.buildTargetEntries();
        targetEntries.values().forEach(it -> {
            graph.addNode((DocumentationEntry)it.getLeft());
            graph.addNode((DocumentationEntry)it.getRight());
            graph.addEdge(beforeAll, (DocumentationEntry)it.getLeft());
            graph.addEdge((DocumentationEntry)it.getLeft(), (DocumentationEntry)it.getRight());
            graph.addEdge((DocumentationEntry)it.getRight(), afterAll);
        });
        this.entries.values().forEach(graph::addNode);
        this.entries.values().forEach(entry -> {
            AtomicBoolean preAdded = new AtomicBoolean(false);
            AtomicBoolean postAdded = new AtomicBoolean(false);
            entry.getDependencies().stream().filter(it -> it.getOrdering() == Dependency.Ordering.AFTER).forEach(it -> {
                preAdded.set(true);
                ResourceLocation target = it.getTarget();
                String targetNamespace = target.func_110624_b();
                graph.addEdge((DocumentationEntry)((Pair)targetEntries.get(targetNamespace)).getLeft(), (DocumentationEntry)entry);
                DocumentationEntry targetEntry = this.entries.get(target);
                if (targetEntry != null) {
                    graph.addEdge(this.entries.get(target), (DocumentationEntry)entry);
                } else if (it.getRequirement() == Dependency.Requirement.REQUIRED) {
                    throw new UnsatisfiedDependencyException("Entry '" + entry.getRegistryName() + "' is specifying a required dependency on '" + target + "', but that entry does not exist");
                }
            });
            entry.getDependencies().stream().filter(it -> it.getOrdering() == Dependency.Ordering.BEFORE).forEach(it -> {
                postAdded.set(true);
                ResourceLocation target = it.getTarget();
                String targetNamespace = target.func_110624_b();
                graph.addEdge((DocumentationEntry)entry, (DocumentationEntry)((Pair)targetEntries.get(targetNamespace)).getRight());
                DocumentationEntry targetEntry = this.entries.get(target);
                if (targetEntry != null) {
                    graph.addEdge((DocumentationEntry)entry, this.entries.get(target));
                } else if (it.getRequirement() == Dependency.Requirement.REQUIRED) {
                    throw new UnsatisfiedDependencyException("Entry '" + entry.getRegistryName() + "' is specifying a required dependency on '" + target + "', but that entry does not exist");
                }
            });
            ResourceLocation registryName = Objects.requireNonNull(entry.getRegistryName());
            String modNamespace = registryName.func_110624_b();
            if (!preAdded.get()) {
                graph.addEdge((DocumentationEntry)((Pair)targetEntries.get(modNamespace)).getKey(), (DocumentationEntry)entry);
            }
            if (!postAdded.get()) {
                graph.addEdge((DocumentationEntry)entry, (DocumentationEntry)((Pair)targetEntries.get(modNamespace)).getValue());
            }
        });
        List<DocumentationEntry> sortedData = TopologicalSort.INSTANCE.sort(graph);
        sortedData.remove(beforeAll);
        sortedData.remove(afterAll);
        targetEntries.values().forEach(it -> {
            sortedData.remove(it.getLeft());
            sortedData.remove(it.getRight());
        });
        return sortedData;
    }

    @Nonnull
    private Map<String, Pair<DocumentationEntry, DocumentationEntry>> buildTargetEntries() {
        HashMap<String, Pair<DocumentationEntry, DocumentationEntry>> targetEntries = new HashMap<String, Pair<DocumentationEntry, DocumentationEntry>>();
        Loader.instance().getModList().stream().map(ModContainer::getModId).map(it -> ImmutablePair.of((Object)it, (Object)ImmutablePair.of((Object)new SortingDocumentationEntry("before_" + it), (Object)new SortingDocumentationEntry("after_" + it)))).forEach(it -> {
            Pair cfr_ignored_0 = (Pair)targetEntries.put((String)it.getLeft(), (Pair<DocumentationEntry, DocumentationEntry>)it.getRight());
        });
        return targetEntries;
    }
}

