/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.common.sort;

import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.common.sort.CyclingDependencyException;
import com.aaronhowser1.dymm.common.sort.DirectedGraph;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;

public enum TopologicalSort {
    INSTANCE;


    @Nonnull
    public List<DocumentationEntry> sort(@Nonnull DirectedGraph<DocumentationEntry> data) {
        return this.doSort(data);
    }

    @Nonnull
    private <T> List<T> doSort(@Nonnull DirectedGraph<T> data) {
        DirectedGraph<Object> reversed = this.reverse(data);
        ArrayList sortedResult = new ArrayList();
        HashSet visitedNodes = new HashSet();
        HashSet expandedNodes = new HashSet();
        reversed.forEach(it -> this.explore(it, reversed, sortedResult, visitedNodes, expandedNodes));
        return sortedResult;
    }

    @Nonnull
    private <T> DirectedGraph<T> reverse(@Nonnull DirectedGraph<T> graph) {
        DirectedGraph result = new DirectedGraph();
        graph.forEach(result::addNode);
        graph.forEach(from -> graph.edgesFrom(from).forEach(to -> result.addEdge(to, from)));
        return result;
    }

    private <T> void explore(@Nonnull T node, @Nonnull DirectedGraph<T> graph, @Nonnull List<T> sortedResult, @Nonnull Set<T> visitedNodes, @Nonnull Set<T> expandedNodes) {
        if (visitedNodes.contains(node)) {
            if (expandedNodes.contains(node)) {
                return;
            }
            throw new CyclingDependencyException("A cycle was identified in the dependency tree: unable to sort.\nThe currently visiting node was '" + node + "'\nThe currently sorted list is " + sortedResult + "\nThe visited set for this node is " + visitedNodes + "\nThe currently explored node set is " + expandedNodes + "\nCycle may be in " + Sets.difference(visitedNodes, expandedNodes));
        }
        visitedNodes.add(node);
        graph.edgesFrom(node).forEach(it -> this.explore(it, graph, sortedResult, visitedNodes, expandedNodes));
        sortedResult.add(node);
        expandedNodes.add(node);
    }
}

