/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.loading.metadata.MetadataListener;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import javax.annotation.Nonnull;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public final class ConfigurationMetadataListener
implements MetadataListener {
    private static final L LOG = L.create("Document Your Mod Mod", "Configuration Metadata Processor");

    ConfigurationMetadataListener() {
    }

    @Override
    public void processMetadata(@Nonnull JsonObject object, @Nonnull String nameSpace) {
        LOG.info("Attempting to process _configuration metadata file for namespace '" + nameSpace + "'");
        try {
            String version = JsonUtilities.getStringOrElse(object, "version", () -> "1");
            LOG.debug("Attempting to load and/or create configuration file with version '" + version + "'");
            Configuration configuration = ApiBindings.getMainApi().getConfigurationManager().getVersionedConfigurationFor(nameSpace, version);
            if (!this.versionMatches(configuration.getLoadedConfigVersion(), version)) {
                LOG.warn("Attempted to load a configuration version that does not match: found '" + configuration.getLoadedConfigVersion() + "', but expected '" + version + "'");
                this.migrateConfiguration(configuration, object);
            }
            this.populateConfigurationObjectWith(configuration, object);
            configuration.save();
            LOG.debug("Configuration loaded, created, and saved correctly");
        }
        catch (Exception e) {
            throw new JsonSyntaxException("The given _configuration.json file for namespace '" + nameSpace + "' does not respect the correct structure", (Throwable)e);
        }
    }

    private boolean versionMatches(@Nonnull String found, @Nonnull String expected) {
        return expected.equals(found);
    }

    private void migrateConfiguration(@Nonnull Configuration configuration, @Nonnull JsonObject object) {
        if (!object.has("migration_instructions")) {
            LOG.bigError("No migration instruction provided: the configuration will not be converted to the new version!", L.DumpStackBehavior.DO_NOT_DUMP);
            return;
        }
        LOG.bigWarn("Configuration migration not yet supported", L.DumpStackBehavior.DO_NOT_DUMP);
    }

    private void populateConfigurationObjectWith(@Nonnull Configuration configuration, @Nonnull JsonObject object) {
        if (!object.has("categories")) {
            return;
        }
        JsonUtilities.getJsonObject(object, "categories").entrySet().forEach(it -> {
            String categoryName = (String)it.getKey();
            JsonObject categoryDescription = JsonUtilities.asJsonObject((JsonElement)it.getValue(), (String)it.getKey());
            this.setupCategory(categoryName, categoryDescription, configuration);
            this.setupProperties(categoryName, configuration, JsonUtilities.getJsonObjectOrElse(categoryDescription, "properties", JsonObject::new));
        });
    }

    private void setupCategory(@Nonnull String name, @Nonnull JsonObject description, @Nonnull Configuration configuration) {
        ConfigCategory category = configuration.getCategory(name);
        if (description.has("comment")) {
            category.setComment(JsonUtilities.getString(description, "comment"));
        }
        if (description.has("language_key")) {
            category.setLanguageKey(JsonUtilities.getString(description, "language_key"));
        }
    }

    private void setupProperties(@Nonnull String mainCategory, @Nonnull Configuration configuration, @Nonnull JsonObject properties) {
        if (properties.entrySet().isEmpty()) {
            LOG.warn("Category '" + mainCategory + "' has no properties specified: while not illegal this is generally useless; the entry will be skipped");
            return;
        }
        properties.entrySet().forEach(it -> {
            String propertyName = (String)it.getKey();
            JsonObject propertyDescription = JsonUtilities.asJsonObject((JsonElement)it.getValue(), (String)it.getKey());
            this.setupProperty(mainCategory, propertyName, propertyDescription, configuration);
        });
    }

    private void setupProperty(@Nonnull String category, @Nonnull String name, @Nonnull JsonObject description, @Nonnull Configuration configuration) {
        boolean def = JsonUtilities.getBooleanOrElse(description, "default", () -> {
            throw new JsonParseException("Only boolean values are supported in the metadata file");
        });
        Property property = configuration.get(category, name, def);
        if (description.has("comment")) {
            property.setComment(JsonUtilities.getString(description, "comment"));
        }
        if (description.has("language_key")) {
            property.setLanguageKey(JsonUtilities.getString(description, "language_key"));
        }
        property.setRequiresMcRestart(JsonUtilities.getBooleanOrElse(description, "requires_restart", () -> true));
    }
}

