/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.documentation.Dependency;
import com.aaronhowser1.dymm.api.documentation.DocumentationData;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.DocumentationLoader;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.api.loading.metadata.MetadataListenerRegistry;
import com.aaronhowser1.dymm.module.base.BasicDependency;
import com.aaronhowser1.dymm.module.base.BasicDocumentationData;
import com.aaronhowser1.dymm.module.base.BasicDocumentationEntry;
import com.aaronhowser1.dymm.module.base.ConfigurationMetadataListener;
import com.aaronhowser1.dymm.module.base.SupportedVersionsMetadataListener;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactoriesMetadataListener;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;

public final class DefaultDocumentationLoader
implements DocumentationLoader {
    @Override
    @Nonnull
    public ResourceLocation getIdentifier() {
        return new ResourceLocation("dymm", "default");
    }

    @Override
    @Nullable
    public DocumentationEntry loadFromJson(@Nonnull JsonObject object) {
        JsonArray conditions = JsonUtilities.getJsonArrayOrElse(object, "conditions", JsonArray::new);
        if (!this.doConditionsPass(conditions)) {
            return null;
        }
        Set<Dependency> dependencies = this.parseDependencies(JsonUtilities.getJsonArrayOrElse(object, "dependencies", JsonArray::new));
        Set<Target> targets = this.parseTargets(JsonUtilities.getJsonArray(object, "targets"));
        Set<DocumentationData> data = this.parseData(JsonUtilities.getJsonArray(object, "data"));
        return BasicDocumentationEntry.create(targets, data, dependencies);
    }

    @Override
    public void registerMetadataListeners(@Nonnull MetadataListenerRegistry registry) {
        registry.register("configuration", new ConfigurationMetadataListener());
        registry.register("supported_versions", new SupportedVersionsMetadataListener());
        registry.register("nbt_factories", new NbtFactoriesMetadataListener());
    }

    private boolean doConditionsPass(@Nonnull JsonArray conditions) {
        return JsonUtilities.checkEntriesAsJsonObjects(conditions, "conditions", this::doesConditionPass);
    }

    private boolean doesConditionPass(@Nonnull JsonObject jsonCondition) {
        ResourceLocation type = new ResourceLocation(JsonUtilities.getString(jsonCondition, "type"));
        GlobalLoadingState state = Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState());
        ConditionFactory factory = state.getConditionFactory(type);
        Condition condition = factory.fromJson(state, jsonCondition);
        return condition.canParse();
    }

    @Nonnull
    private Set<Dependency> parseDependencies(@Nonnull JsonArray dependencies) {
        HashSet<Dependency> dependencySet = new HashSet<Dependency>();
        JsonUtilities.consumeEntriesAsJsonObjects(dependencies, "dependencies", it -> dependencySet.add(this.parseDependency((JsonObject)it)));
        return dependencySet;
    }

    @Nonnull
    private Dependency parseDependency(@Nonnull JsonObject jsonDependency) {
        if (!jsonDependency.has("ordering") && !jsonDependency.has("requirement")) {
            throw new JsonSyntaxException("A dependency declaration must have either an 'ordering' or a 'requirement' property");
        }
        Dependency.Ordering ordering = this.getOrderingFromString(JsonUtilities.getStringOrElse(jsonDependency, "ordering", () -> "either"));
        Dependency.Requirement requirement = this.getRequirementFromString(JsonUtilities.getStringOrElse(jsonDependency, "requirement", () -> "optional"));
        if (ordering == Dependency.Ordering.EITHER && requirement == Dependency.Requirement.OPTIONAL) {
            throw new JsonSyntaxException("An optional dependency must specify an ordering property, or be declared as required instead");
        }
        ResourceLocation target = new ResourceLocation(JsonUtilities.getString(jsonDependency, "target"));
        return BasicDependency.create(ordering, requirement, target);
    }

    @Nonnull
    private Dependency.Ordering getOrderingFromString(@Nonnull String string) {
        return (Dependency.Ordering)((Object)this.getFromEnum(string, Dependency.Ordering::values, it -> "The given string '" + it + "' is not a valid value for 'ordering'"));
    }

    @Nonnull
    private Dependency.Requirement getRequirementFromString(@Nonnull String string) {
        return (Dependency.Requirement)((Object)this.getFromEnum(string, Dependency.Requirement::values, it -> "The given string '" + it + "' is not a valid value for 'requirement'"));
    }

    @Nonnull
    private <T extends Enum<T>> T getFromEnum(@Nonnull String string, @Nonnull Supplier<T[]> valuesSupplier, @Nonnull Function<String, String> errorMessage) {
        Set allowedNames = Arrays.stream(valuesSupplier.get()).map(Enum::name).map(it -> it.toLowerCase(Locale.ENGLISH)).collect(Collectors.toSet());
        if (!allowedNames.contains(string)) {
            throw new JsonParseException(errorMessage.apply(string));
        }
        return (T)Arrays.stream(valuesSupplier.get()).filter(it -> it.name().equals(string.toUpperCase(Locale.ENGLISH))).findFirst().orElseThrow(RuntimeException::new);
    }

    @Nonnull
    private Set<Target> parseTargets(@Nonnull JsonArray targets) {
        if (targets.size() <= 0) {
            throw new JsonParseException("A documentation entry must have at least one target");
        }
        HashSet<Target> targetSet = new HashSet<Target>();
        JsonUtilities.consumeEntriesAsJsonObjects(targets, "targets", it -> targetSet.addAll(this.parseTarget((JsonObject)it)));
        return targetSet;
    }

    @Nonnull
    private List<Target> parseTarget(@Nonnull JsonObject jsonTarget) {
        ResourceLocation type = new ResourceLocation(JsonUtilities.getString(jsonTarget, "type"));
        GlobalLoadingState state = Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState());
        TargetFactory factory = state.getTargetFactory(type);
        return factory.fromJson(state, jsonTarget);
    }

    @Nonnull
    private Set<DocumentationData> parseData(@Nonnull JsonArray jsonData) {
        if (jsonData.size() == 0) {
            Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().report("This entry has no documentation data associated with it: this is useless. The entry will be registered anyway, but it will not appear anywhere", new Object[0]);
            return new HashSet<DocumentationData>();
        }
        HashSet<DocumentationData> data = new HashSet<DocumentationData>();
        JsonUtilities.consumeEntriesAsJsonObjects(jsonData, "data", it -> data.add(this.parseData((JsonObject)it)));
        return data;
    }

    @Nonnull
    private DocumentationData parseData(@Nonnull JsonObject object) {
        ResourceLocation type = new ResourceLocation(JsonUtilities.getString(object, "type"));
        ArrayList<String> data = new ArrayList<String>();
        try {
            JsonArray dataArray = JsonUtilities.getJsonArray(object, "data");
            for (int i = 0; i < dataArray.size(); ++i) {
                String item = JsonUtilities.asString(dataArray.get(i), "data[" + i + "]");
                if (item.isEmpty()) {
                    Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().notify("This entry presents an empty string inside its data page: this is usually the result of a mistake", new Object[0]);
                }
                data.add(item);
            }
        }
        catch (JsonSyntaxException e) {
            String dataString = JsonUtilities.getString(object, "data");
            if (dataString.isEmpty()) {
                Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().notify("This entry presents an empty string inside its data page: this is usually the result of a mistake", new Object[0]);
            }
            data.add(dataString);
        }
        return BasicDocumentationData.buildFrom(type, data);
    }
}

