/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Dependency;
import com.aaronhowser1.dymm.api.documentation.DocumentationData;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.DocumentationLoader;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.Reporter;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.api.loading.metadata.MetadataListenerRegistry;
import com.aaronhowser1.dymm.module.base.BasicDocumentationEntry;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class UndocumentedTargetsPlaceholderLoader
implements DocumentationLoader {
    private static final L LOG = L.create("Document Your Mod Mod", "Undocumented Targets Listener");
    private boolean hasRegistered = false;
    private final Queue<Pair<JsonObject, String>> undocumentedItemsQueue = new LinkedList<Pair<JsonObject, String>>();

    @Override
    @Nonnull
    public ResourceLocation getIdentifier() {
        return new ResourceLocation("dymm", "undocumented_targets_preloaded");
    }

    @Override
    @Nullable
    public DocumentationEntry loadFromJson(@Nonnull JsonObject object) {
        Reporter reporter = Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter();
        if (this.hasRegistered) {
            reporter.interrupt("A placeholder entry has already been registered! If you're attempting to use this loader for your own entries, DON'T! THIS IS NOT FOR EXTERNAL USE!", new Object[0]);
            return null;
        }
        this.hasRegistered = true;
        HashSet targets = new HashSet();
        this.undocumentedItemsQueue.stream().map(this::parseUndocumentedTargets).forEach(targets::addAll);
        this.undocumentedItemsQueue.clear();
        reporter.notify("The undocumented targets placeholder registered successfully, with a total of " + targets.size() + " entries", new Object[0]);
        return BasicDocumentationEntry.create(new HashSet<Target>(targets), new HashSet<DocumentationData>(), new HashSet<Dependency>());
    }

    @Override
    public void registerMetadataListeners(@Nonnull MetadataListenerRegistry registry) {
        registry.register("undocumented_targets", (object, namespace) -> {
            LOG.info("Found undocumented targets metadata for namespace '" + namespace + "': enqueueing processing");
            this.undocumentedItemsQueue.add((Pair<JsonObject, String>)ImmutablePair.of((Object)object, (Object)namespace));
        });
    }

    @Nonnull
    private Set<Target> parseUndocumentedTargets(@Nonnull Pair<JsonObject, String> pair) {
        return this.parseUndocumentedTargets((JsonObject)pair.getLeft(), (String)pair.getRight());
    }

    @Nonnull
    private Set<Target> parseUndocumentedTargets(@Nonnull JsonObject object, @Nonnull String namespace) {
        LOG.info("Parsing purposefully undocumented targets for namespace '" + namespace + "'");
        if (!object.has("targets")) {
            LOG.warn("The metadata-carrying entry for '" + namespace + "' has an empty target list! This is useless!");
        }
        return this.parseTargets(JsonUtilities.getJsonArrayOrElse(object, "targets", JsonArray::new));
    }

    @Nonnull
    private Set<Target> parseTargets(@Nonnull JsonArray targets) {
        if (targets.size() <= 0) {
            throw new JsonParseException("No target specified: this is a serious error!");
        }
        HashSet<Target> targetSet = new HashSet<Target>();
        JsonUtilities.consumeEntriesAsJsonObjects(targets, "targets", it -> targetSet.addAll(this.parseTarget((JsonObject)it)));
        return targetSet;
    }

    @Nonnull
    private List<Target> parseTarget(@Nonnull JsonObject jsonTarget) {
        ResourceLocation type = new ResourceLocation(JsonUtilities.getString(jsonTarget, "type"));
        GlobalLoadingState state = Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState());
        TargetFactory factory = state.getTargetFactory(type);
        return factory.fromJson(state, jsonTarget);
    }
}

