/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.aaronhowser1.dymm.module.base.BasicItemTarget;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public final class SpawnEggTargetFactory
implements TargetFactory {
    @Override
    @Nonnull
    public List<Target> fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String entityId = JsonUtilities.getString(object, "id");
        ItemStack stack = new ItemStack(Items.field_151063_bx, 1, 0);
        stack.deserializeNBT(this.createNbt(state, entityId));
        ArrayList<Target> target = new ArrayList<Target>();
        target.add(new BasicItemTarget(stack));
        return target;
    }

    @Nonnull
    private NBTTagCompound createNbt(@Nonnull GlobalLoadingState state, @Nonnull String id) {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a("tag", (NBTBase)this.createTag(state, id));
        return tag;
    }

    @Nonnull
    private NBTTagCompound createTag(@Nonnull GlobalLoadingState state, @Nonnull String id) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        NBTTagCompound entityTag = new NBTTagCompound();
        entityTag.func_74778_a("id", this.checkIdValid(state, id));
        tagCompound.func_74782_a("EntityTag", (NBTBase)entityTag);
        return tagCompound;
    }

    @Nonnull
    private String checkIdValid(@Nonnull GlobalLoadingState state, @Nonnull String id) {
        EntityEntry entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(id));
        if (entry == null) {
            state.getReporter().report("The given entity ID '" + id + "' does not exist: the entry will be registered anyway, but it won't work!", new Object[0]);
        }
        return id;
    }
}

