/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.nbt;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactory;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactoryRegistry;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;

public final class CompoundNbtFactory
implements NbtFactory<NBTTagCompound> {
    @Override
    @Nonnull
    public NBTTagCompound parseFromJson(@Nonnull String keyName, @Nonnull JsonElement value, int depthLevel) {
        NBTTagCompound compound = new NBTTagCompound();
        JsonObject jsonCompound = JsonUtilities.asJsonObject(value, keyName);
        jsonCompound.entrySet().forEach(entry -> {
            String longKey = (String)entry.getKey();
            int colon = longKey.lastIndexOf(58);
            String key = longKey.substring(0, colon);
            String mnemonic = longKey.substring(colon + 1);
            int newDepthLevel = depthLevel + 1;
            if (newDepthLevel > 10) {
                throw new JsonParseException("Reached NBT that is too deep for parsing: more than 10 nested levels");
            }
            compound.func_74782_a(key, NbtFactoryRegistry.INSTANCE.getForType(mnemonic).parseFromJson(key, (JsonElement)entry.getValue(), newDepthLevel));
        });
        return compound;
    }
}

