/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.base.nbt;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactory;
import com.aaronhowser1.dymm.module.base.nbt.NbtFactoryRegistry;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagList;

public final class ListNbtFactory
implements NbtFactory<NBTTagList> {
    @Override
    @Nonnull
    public NBTTagList parseFromJson(@Nonnull String keyName, @Nonnull JsonElement value, int depthLevel) {
        int colon = keyName.lastIndexOf(58);
        String name = keyName.substring(0, colon);
        String insideType = keyName.substring(colon + 1);
        JsonArray array = JsonUtilities.asJsonArray(value, name);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < array.size(); ++i) {
            JsonElement element = array.get(i);
            int newDepthLevel = depthLevel + 1;
            if (newDepthLevel > 10) {
                throw new JsonParseException("Reached NBT that is too deep for parsing: more than 10 nested levels");
            }
            Object base = NbtFactoryRegistry.INSTANCE.getForType(insideType).parseFromJson(name + "[" + i + "]", element, newDepthLevel);
            list.func_74742_a(base);
        }
        return list;
    }
}

