/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.inspirations.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;

public final class PulseLoadedConditionFactory
implements ConditionFactory {
    private static final Condition FALSE = new BasicCondition(false);
    private static final Condition TRUE = new BasicCondition(true);
    private static final Map<String, Condition> PULSE_CACHE = new HashMap<String, Condition>();

    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String pulseName = JsonUtilities.getString(object, "pulse");
        if (!pulseName.toLowerCase(Locale.ENGLISH).equals(pulseName)) {
            throw new JsonSyntaxException("Pulse name '" + pulseName + "' is invalid: must be lowercase");
        }
        return PULSE_CACHE.computeIfAbsent(pulseName, this::findConditionForPulse);
    }

    @Nonnull
    private Condition findConditionForPulse(@Nonnull String pulseName) {
        try {
            return this.calculateConditionForPulse(pulseName);
        }
        catch (ReflectiveOperationException e) {
            throw new JsonParseException("The given pulse '" + pulseName + "' does not exist!");
        }
    }

    @Nonnull
    private Condition calculateConditionForPulse(@Nonnull String pulseName) throws ReflectiveOperationException {
        String className = "Inspirations" + StringUtils.capitalize((String)pulseName);
        Class<?> pulseClass = Class.forName(String.format("knightminer.inspirations.%s.%s", pulseName, className));
        Class<?> inspirationsMainClass = Class.forName("knightminer.inspirations.Inspirations");
        Field pulseManagerField = inspirationsMainClass.getDeclaredField("pulseManager");
        pulseManagerField.setAccessible(true);
        Object pulseManager = pulseManagerField.get(inspirationsMainClass);
        Class<?> pulseManagerClass = Class.forName("slimeknights.mantle.pulsar.control.PulseManager");
        Field pulsesField = pulseManagerClass.getDeclaredField("pulses");
        pulsesField.setAccessible(true);
        Map pulses = (Map)pulsesField.get(pulseManager);
        for (Map.Entry pulse : pulses.entrySet()) {
            if (!this.checkIfTargetPulse(pulseClass, pulse.getKey()) || !this.isPulseEnabled(pulse.getValue())) continue;
            return TRUE;
        }
        return FALSE;
    }

    private boolean checkIfTargetPulse(@Nonnull Class<?> pulseClass, @Nonnull Object pulse) {
        return pulse.getClass().equals(pulseClass);
    }

    private boolean isPulseEnabled(@Nonnull Object pulseMetadata) throws ReflectiveOperationException {
        Class<?> pulseMetadataClass = pulseMetadata.getClass();
        Method isEnabled = pulseMetadataClass.getDeclaredMethod("isEnabled", new Class[0]);
        isEnabled.setAccessible(true);
        return (Boolean)isEnabled.invoke(pulseMetadata, new Object[0]);
    }
}

