/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.minecraft.consume;

import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.consume.DocumentationDataConsumer;
import com.aaronhowser1.dymm.api.documentation.DocumentationData;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;

public final class TooltipDocumentationConsumer
implements DocumentationDataConsumer {
    private static final Map<Target, List<Pair<TextFormatting, String>>> TARGET_ENTRIES = new HashMap<Target, List<Pair<TextFormatting, String>>>();

    @Override
    @Nonnull
    public List<ResourceLocation> getCompatibleTypes() {
        return ImmutableList.of((Object)new ResourceLocation("minecraft", "tooltip"));
    }

    @Override
    public void consumeData(@Nonnull DocumentationData data, @Nonnull Set<Target> targets) {
        targets.forEach(target -> TARGET_ENTRIES.computeIfAbsent((Target)target, key -> new ArrayList()).addAll(this.convert(data.getData())));
    }

    @Override
    public void onCreation() {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    @Nonnull
    private List<Pair<TextFormatting, String>> convert(@Nonnull List<String> strings) {
        return strings.stream().map(this::convert).collect(Collectors.toList());
    }

    @Nonnull
    private Pair<TextFormatting, String> convert(@Nonnull String string) {
        if (string.startsWith("[")) {
            int indexOf = string.indexOf(93);
            String sub = string.substring(1, indexOf);
            String other = string.substring(indexOf + 1);
            return ImmutablePair.of((Object)TextFormatting.func_96300_b((String)sub), (Object)other);
        }
        return ImmutablePair.of(null, (Object)string);
    }

    @SubscribeEvent
    public void onItemTooltip(@Nonnull ItemTooltipEvent event) {
        ((List)LoadingCacheLazyLoaders.STACKS_CACHE.getUnchecked((Object)event.getItemStack())).forEach(it -> {
            String line = it.getLeft() == null ? I18n.func_135052_a((String)((String)it.getRight()), (Object[])new Object[0]) : "" + ((TextFormatting)it.getLeft()).toString() + I18n.func_135052_a((String)((String)it.getRight()), (Object[])new Object[0]) + TextFormatting.RESET.toString();
            event.getToolTip().add(line);
        });
    }

    private static final class LoadingCacheLazyLoaders {
        private static final LoadingCache<ResourceLocation, List<DocumentationEntry>> DOCUMENTATION_CACHE = LoadingCacheLazyLoaders.createBuilder(2000L).expireAfterAccess(5L, TimeUnit.MINUTES).expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<ResourceLocation, List<DocumentationEntry>>(){

            @Nonnull
            public List<DocumentationEntry> load(@Nonnull ResourceLocation key) {
                return ApiBindings.getMainApi().getDocumentationRegistry().getValuesCollection().stream().filter(it -> it.getTargets().stream().map(Target::obtainTarget).map(ItemStack::func_77973_b).map(IForgeRegistryEntry.Impl::getRegistryName).peek(Objects::requireNonNull).anyMatch(arg_0 -> ((ResourceLocation)key).equals(arg_0))).collect(Collectors.toList());
            }
        });
        private static final LoadingCache<ItemStack, List<Pair<TextFormatting, String>>> STACKS_CACHE = LoadingCacheLazyLoaders.createBuilder(7000L).expireAfterAccess(3L, TimeUnit.SECONDS).expireAfterWrite(5L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<ItemStack, List<Pair<TextFormatting, String>>>(){

            @Nonnull
            public List<Pair<TextFormatting, String>> load(@Nonnull ItemStack key) {
                ResourceLocation registryName = key.func_77973_b().getRegistryName();
                if (registryName == null) {
                    return new ArrayList<Pair<TextFormatting, String>>();
                }
                List candidates = (List)DOCUMENTATION_CACHE.getUnchecked((Object)registryName);
                ArrayList<Pair<TextFormatting, String>> lines = new ArrayList<Pair<TextFormatting, String>>();
                candidates.forEach(candidate -> {
                    boolean matches = false;
                    for (Target target : candidate.getTargets()) {
                        if (matches) break;
                        ItemStack stack = target.obtainTarget();
                        matches = ItemStack.func_179545_c((ItemStack)stack, (ItemStack)key);
                        if (matches && stack.func_77942_o() && !(matches = ItemStack.func_77970_a((ItemStack)stack, (ItemStack)key))) {
                            if (key.func_82837_s() && stack.func_82837_s() || !key.func_82837_s()) continue;
                            stack.func_151001_c(key.func_82833_r());
                            matches = ItemStack.func_77970_a((ItemStack)stack, (ItemStack)key);
                        }
                        if (!matches || TARGET_ENTRIES.get(target) == null) continue;
                        lines.addAll((Collection)TARGET_ENTRIES.get(target));
                    }
                });
                return lines;
            }
        });

        private LoadingCacheLazyLoaders() {
        }

        private static CacheBuilder<Object, Object> createBuilder(long maximumSize) {
            Configuration config = ApiBindings.getMainApi().getConfigurationManager().getConfigurationFor("_main");
            boolean isRamSaving = config.getBoolean("ram_saving", "performance", false, "Makes the mod run in RAM-light mode, making it allocate as few resources as possible.\nWARNING! This WILL exponentially decrease performance up to 70%! Use this option if you REALLY need to spare as much RAM as possible!\nIn most cases this mod can automatically regulate itself, so turn this on ONLY if you've already tried everything! Do NOT come to us for huge slowdowns");
            CacheBuilder builder = CacheBuilder.newBuilder();
            return isRamSaving ? builder.maximumSize(maximumSize) : builder;
        }
    }
}

