/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quark.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.common.base.CaseFormat;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;

public final class ExperimentalFeatureEnabledConditionFactory
implements ConditionFactory {
    private static final Map<String, Condition> FEATURE_CACHE = new HashMap<String, Condition>();

    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String feature = JsonUtilities.getString(object, "feature");
        if (!feature.toLowerCase(Locale.ENGLISH).equals(feature)) {
            throw new JsonSyntaxException("Feature name '" + feature + "' is invalid: must be lowercase");
        }
        try {
            if (!this.isModuleEnabled()) {
                state.getReporter().notify("Skipping condition checking for feature '" + feature + "' since parent module 'experimental' isn't enabled", new Object[0]);
                return new BasicCondition(false);
            }
        }
        catch (ReflectiveOperationException e) {
            throw new JsonParseException("Given module 'experimental' couldn't be found", (Throwable)e);
        }
        return FEATURE_CACHE.computeIfAbsent(feature, it -> {
            try {
                return new BasicCondition(this.isFeatureEnabled((String)it));
            }
            catch (ReflectiveOperationException e) {
                throw new JsonParseException("Given feature '" + it + "' couldn't be found in module 'experimental'", (Throwable)e);
            }
        });
    }

    private boolean isModuleEnabled() throws ReflectiveOperationException {
        Class<?> targetClass = Class.forName("vazkii.quark.experimental.QuarkExperimental");
        Class<?> moduleClass = Class.forName("vazkii.quark.base.module.Module");
        if (!moduleClass.isAssignableFrom(targetClass)) {
            throw new JsonParseException("The given module 'experimental' is not a valid Quark module");
        }
        Class<?> moduleLoader = Class.forName("vazkii.quark.base.module.ModuleLoader");
        Method isModuleEnabled = moduleLoader.getDeclaredMethod("isModuleEnabled", Class.class);
        isModuleEnabled.setAccessible(true);
        Object result = isModuleEnabled.invoke(moduleLoader, targetClass);
        if (!(result instanceof Boolean)) {
            throw new ReflectiveOperationException("Result was not a boolean: maybe another method?");
        }
        return (Boolean)result;
    }

    private boolean isFeatureEnabled(@Nonnull String feature) throws ReflectiveOperationException {
        String className = this.toClassName(feature);
        Class<?> targetClass = Class.forName(String.format("vazkii.quark.experimental.features.%s", className));
        Class<?> featureClass = Class.forName("vazkii.quark.base.module.Feature");
        if (!featureClass.isAssignableFrom(targetClass)) {
            throw new JsonParseException("The given feature '" + feature + "' in module 'experimental' is not a valid Quark feature");
        }
        Class<?> moduleLoader = Class.forName("vazkii.quark.base.module.ModuleLoader");
        Method isFeatureEnabled = moduleLoader.getDeclaredMethod("isFeatureEnabled", Class.class);
        isFeatureEnabled.setAccessible(true);
        Object result = isFeatureEnabled.invoke(moduleLoader, targetClass);
        if (!(result instanceof Boolean)) {
            throw new ReflectiveOperationException("Result was not a boolean: maybe another method?");
        }
        return (Boolean)result;
    }

    @Nonnull
    private String toClassName(@Nonnull String feature) {
        return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, feature);
    }
}

