/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quark.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class ExtraPotionConditionFactory
implements ConditionFactory {
    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String targetPotion = JsonUtilities.getString(object, "potion");
        Potion potion = Arrays.stream(Potion.values()).filter(it -> targetPotion.equals(it.name().toLowerCase(Locale.ENGLISH))).findFirst().orElseThrow(() -> new JsonSyntaxException("Unrecognized potion '" + targetPotion + "'"));
        return new BasicCondition(this.reflectInto(potion));
    }

    private boolean reflectInto(@Nonnull Potion potion) {
        try {
            Class<?> target = Class.forName("vazkii.quark.misc.feature.ExtraPotions");
            Field targetField = target.getDeclaredField(potion.getFieldName());
            targetField.setAccessible(true);
            return (Boolean)targetField.get(null);
        }
        catch (ReflectiveOperationException e) {
            Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().interrupt("Unable to determine presence of Extra Potion '" + (Object)((Object)potion) + "'! Returning false to be safe!", new Object[0]);
            return false;
        }
    }

    private static enum Potion {
        HASTE("enableHaste"),
        RESISTANCE("enableResistance"),
        DANGER_SIGHT("enableDangerSight");

        private final String fieldName;

        private Potion(String fieldName) {
            this.fieldName = fieldName;
        }

        @Nonnull
        private String getFieldName() {
            return this.fieldName;
        }
    }
}

