/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quark.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class TreeVariantsGenerationStatusConditionFactory
implements ConditionFactory {
    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String targetVariant = JsonUtilities.getString(object, "variant");
        Variant variant = Arrays.stream(Variant.values()).filter(it -> targetVariant.equals(it.name().toLowerCase(Locale.ENGLISH))).findFirst().orElseThrow(() -> new JsonSyntaxException("Unrecognized variant '" + targetVariant + "'"));
        return new BasicCondition(this.reflectInto(variant));
    }

    private boolean reflectInto(@Nonnull Variant variant) {
        try {
            Class<?> target = Class.forName("vazkii.quark.world.feature.TreeVariants");
            Field targetField = target.getDeclaredField(variant.getFieldName());
            targetField.setAccessible(true);
            return (Boolean)targetField.get(null);
        }
        catch (ReflectiveOperationException e) {
            Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().interrupt("Unable to identify variant '" + (Object)((Object)variant) + "' for Tree Variants! Returning false to be safe!", new Object[0]);
            return false;
        }
    }

    private static enum Variant {
        SWAMP("enableSwamp"),
        SAKURA("enableSakura");

        private final String fieldName;

        private Variant(String fieldName) {
            this.fieldName = fieldName;
        }

        @Nonnull
        private String getFieldName() {
            return this.fieldName;
        }
    }
}

