/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quark.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class VanillaDustPlacingStatusConditionFactory
implements ConditionFactory {
    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String targetDust = JsonUtilities.getString(object, "dust");
        Dust dust = Arrays.stream(Dust.values()).filter(it -> targetDust.equals(it.name().toLowerCase(Locale.ENGLISH))).findFirst().orElseThrow(() -> new JsonSyntaxException("Unrecognized dust '" + targetDust + "' for Placeable Dusts"));
        return new BasicCondition(this.reflectInto(dust));
    }

    private boolean reflectInto(@Nonnull Dust dust) {
        try {
            Class<?> target = Class.forName("vazkii.quark.misc.feature.PlaceVanillaDusts");
            Field targetField = target.getDeclaredField(dust.getFieldName());
            targetField.setAccessible(true);
            return (Boolean)targetField.get(null);
        }
        catch (ReflectiveOperationException e) {
            Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().interrupt("Unable to determine dust " + (Object)((Object)dust) + " for Placeable Dusts! Returning false to be safe!", new Object[0]);
            return false;
        }
    }

    private static enum Dust {
        GLOWSTONE("enableGlowstone"),
        GUNPOWDER("enableGunpowder");

        private final String fieldName;

        private Dust(String fieldName) {
            this.fieldName = fieldName;
        }

        @Nonnull
        private String getFieldName() {
            return this.fieldName;
        }
    }
}

