/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.compatibility.quark.factory;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Condition;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.ConditionFactory;
import com.aaronhowser1.dymm.module.base.BasicCondition;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class VariedButtonsPressurePlatesFeatureConditionFactory
implements ConditionFactory {
    @Override
    @Nonnull
    public Condition fromJson(@Nonnull GlobalLoadingState state, @Nonnull JsonObject object) {
        String targetFeature = JsonUtilities.getString(object, "feature");
        Feature feature = Arrays.stream(Feature.values()).filter(it -> targetFeature.equals(it.name().toLowerCase(Locale.ENGLISH))).findFirst().orElseThrow(() -> new JsonSyntaxException("Unrecognized feature '" + targetFeature + "' for Varied Buttons & Pressure Plates"));
        return new BasicCondition(this.reflectInto(feature));
    }

    private boolean reflectInto(@Nonnull Feature feature) {
        try {
            Class<?> target = Class.forName("vazkii.quark.decoration.feature.VariedButtonsAndPressurePlates");
            Field targetField = target.getDeclaredField(feature.getFieldName());
            targetField.setAccessible(true);
            return (Boolean)targetField.get(null);
        }
        catch (ReflectiveOperationException e) {
            Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState()).getReporter().interrupt("Unable to determine feature " + (Object)((Object)feature) + " for buttons and pressure plates! Returning false to be safe!", new Object[0]);
            return false;
        }
    }

    private static enum Feature {
        BUTTON("enableButtons"),
        PLATE("enablePressurePlates");

        private final String fieldName;

        private Feature(String fieldName) {
            this.fieldName = fieldName;
        }

        @Nonnull
        private String getFieldName() {
            return this.fieldName;
        }
    }
}

