/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.module.lazy;

import com.aaronhowser1.dymm.JsonUtilities;
import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.api.ApiBindings;
import com.aaronhowser1.dymm.api.documentation.Dependency;
import com.aaronhowser1.dymm.api.documentation.DocumentationData;
import com.aaronhowser1.dymm.api.documentation.DocumentationEntry;
import com.aaronhowser1.dymm.api.documentation.Target;
import com.aaronhowser1.dymm.api.loading.GlobalLoadingState;
import com.aaronhowser1.dymm.api.loading.factory.TargetFactory;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.IForgeRegistryEntry;

public final class LazyDocumentationEntry
extends IForgeRegistryEntry.Impl<DocumentationEntry>
implements DocumentationEntry {
    private final Set<DocumentationData> data;
    private final Set<Dependency> dependencies;
    private Set<Target> targets = null;
    private JsonArray targetsArray;

    private LazyDocumentationEntry(@Nonnull JsonArray jsonTargets, @Nonnull Set<DocumentationData> data, @Nonnull Set<Dependency> dependencies) {
        this.data = new HashSet<DocumentationData>(data);
        this.dependencies = new HashSet<Dependency>(dependencies);
        this.targetsArray = jsonTargets;
    }

    @Nonnull
    static DocumentationEntry create(@Nonnull JsonArray jsonTargets, @Nonnull Set<DocumentationData> data, @Nonnull Set<Dependency> dependencies) {
        return new LazyDocumentationEntry(Objects.requireNonNull(jsonTargets), Objects.requireNonNull(data), Objects.requireNonNull(dependencies));
    }

    @Override
    @Nonnull
    public Set<Target> getTargets() {
        if (Objects.isNull(this.targets)) {
            this.targets = this.parseTargetsArray();
            this.targetsArray = null;
        }
        return new HashSet<Target>(this.targets);
    }

    @Override
    @Nonnull
    public Set<DocumentationData> getDocumentationData() {
        return new HashSet<DocumentationData>(this.data);
    }

    @Override
    @Nonnull
    public Set<Dependency> getDependencies() {
        return new HashSet<Dependency>(this.dependencies);
    }

    @Nonnull
    private Set<Target> parseTargetsArray() {
        this.setEntryNameToState(Objects.requireNonNull(this.getRegistryName()));
        HashSet<Target> targets = new HashSet<Target>();
        JsonUtilities.consumeEntriesAsJsonObjects(this.targetsArray, "targets", it -> targets.addAll(this.parseTarget((JsonObject)it)));
        return targets;
    }

    @Nonnull
    private List<Target> parseTarget(@Nonnull JsonObject jsonTarget) {
        ResourceLocation type = new ResourceLocation(JsonUtilities.getString(jsonTarget, "type"));
        GlobalLoadingState state = Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState());
        TargetFactory factory = state.getTargetFactory(type);
        return factory.fromJson(state, jsonTarget);
    }

    private void setEntryNameToState(@Nonnull ResourceLocation name) {
        try {
            GlobalLoadingState state = Objects.requireNonNull(ApiBindings.getMainApi().getCurrentLoadingState());
            Class<?> stateClass = state.getClass();
            Field targetId = stateClass.getDeclaredField("targetId");
            targetId.setAccessible(true);
            targetId.set(state, name);
        }
        catch (ReflectiveOperationException e) {
            L.create("dymm", "LazyDocumentationEntry").warn("API implementation replaced: unable to set reg names");
            e.printStackTrace();
        }
    }
}

