/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression;

import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction0;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class WhenExpression<T>
implements KFunction0<T> {
    private final List<Case<T>> cases;
    private final KFunction0<T> elseClause;

    private WhenExpression(@Nonnull List<Case<T>> cases, @Nonnull KFunction0<T> elseClause) {
        this.cases = Objects.requireNonNull(cases);
        this.elseClause = Objects.requireNonNull(elseClause);
    }

    @Nonnull
    public static <T> WhenExpression<T> create(@Nonnull List<Case<T>> cases, @Nonnull KFunction0<T> elseClause) {
        return new WhenExpression<T>(cases, elseClause);
    }

    @Override
    @Nonnull
    public T invoke() {
        return this.cases.stream().filter(rec$ -> ((Case)rec$).matches()).findFirst().map(it -> ((Case)it).function).orElse(this.elseClause).invoke();
    }

    public static final class Case<T>
    implements KFunction0<T> {
        private final boolean test;
        private final KFunction0<T> function;

        private Case(boolean test, @Nonnull KFunction0<T> function) {
            this.test = test;
            this.function = Objects.requireNonNull(function);
        }

        @Nonnull
        public static <T> Case<T> create(boolean test, @Nonnull KFunction0<T> function) {
            return new Case<T>(test, function);
        }

        private boolean matches() {
            return this.test;
        }

        @Override
        @Nonnull
        public T invoke() {
            return this.function.invoke();
        }
    }
}

