/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Lazy;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.ElvisExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.IfExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KClass;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction0;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction1;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.reflect.KFunction2;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.BosonApi;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.id.NameSpacedString;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.ContextKey;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Loader;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.LoaderBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import javax.annotation.Nonnull;

public final class ApiBindings {
    private static final L LOG = L.create("[DYMM Shade] Boson API", "API Bindings");
    public static final Lazy<BosonApi> BOSON_API = Lazy.lazy(() -> ApiBindings.loadWithService(KClass.get(BosonApi.class), () -> new BosonApi(){

        @Override
        @Nonnull
        public NameSpacedString constructNameSpacedString(final @Nonnull Nullable<String> nameSpace, final @Nonnull String path) {
            return new NameSpacedString(){

                @Override
                @Nonnull
                public String getNameSpace() {
                    return ElvisExpression.create(nameSpace, () -> "null").invoke();
                }

                @Override
                @Nonnull
                public String getPath() {
                    return path;
                }

                @Override
                public int compareTo(@Nonnull NameSpacedString o) {
                    return IfExpression.build(this.getNameSpace().compareTo(o.getNameSpace()) == 0, () -> 0, () -> this.getPath().compareTo(o.getPath())).invoke();
                }
            };
        }

        @Override
        @Nonnull
        public <T> ContextKey<T> createLoaderContextKey(final @Nonnull String name, final @Nonnull KClass<T> type) {
            return new ContextKey<T>(){

                @Override
                @Nonnull
                public String getName() {
                    return name;
                }

                @Override
                @Nonnull
                public KClass<T> getType() {
                    return type;
                }
            };
        }

        @Override
        @Nonnull
        public Loader buildLoader(@Nonnull LoaderBuilder builder) {
            return new Loader(){

                @Override
                @Nonnull
                public Unit load() {
                    return Unit.UNIT;
                }
            };
        }
    }));

    private ApiBindings() {
    }

    @Nonnull
    private static <T> T loadWithService(@Nonnull KClass<T> lookUpInterface, @Nonnull KFunction0<T> defaultProvider) {
        KFunction2<KClass, KFunction0, Object> load = (load$lookUpInterface, load$defaultProvider) -> {
            List foundImplementations = ApiBindings.toList(ServiceLoader.load(load$lookUpInterface.java()).iterator());
            if (foundImplementations.size() > 1) {
                LOG.warn("Found multiple implementations for " + load$lookUpInterface.getSimpleName() + " API Bindings: trying to find our own");
                Nullable<Object> bosonImpl = ApiBindings.firstOrNull(foundImplementations, it -> it.getClass().getName().contains("mc.boson.implementation"));
                if (bosonImpl.unwrap() != null) {
                    return bosonImpl.unwrap();
                }
                LOG.bigWarn("Unable to find Boson implementation for " + load$lookUpInterface.getSimpleName() + " API Binding!");
                return foundImplementations.get(0);
            }
            Nullable<Object> impl = ApiBindings.firstOrNull(foundImplementations, it -> true);
            if (impl.unwrap() == null) {
                LOG.bigError("No API Binding found! Replacing with dummy implementation.\nNote that this may lead to future errors");
                return load$defaultProvider.invoke();
            }
            return impl.unwrap();
        };
        Object value = load.invoke(lookUpInterface, defaultProvider);
        LOG.info("Using " + KClass.get(value.getClass()).getQualifiedName() + " as API Binding for Boson class " + lookUpInterface.getQualifiedName());
        return (T)value;
    }

    @Nonnull
    private static <T> List<T> toList(@Nonnull Iterator<T> $this$receiver) {
        ArrayList list = new ArrayList();
        $this$receiver.forEachRemaining(list::add);
        return list;
    }

    @Nonnull
    private static <T> Nullable<T> firstOrNull(@Nonnull List<T> $this$receiver, @Nonnull KFunction1<T, Boolean> predicate) {
        for (T element : $this$receiver) {
            if (!predicate.invoke(element).booleanValue()) continue;
            return Nullable.get(element);
        }
        return Nullable.get(null);
    }
}

