/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.locator;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.CheckedException;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Lazy;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.IfExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Location;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Locator;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.CCK;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.context.BaseContext;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.location.BaseLocation;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public final class ResourcesDirectoryLocator
implements Locator {
    private static final L LOG = L.create("[DYMM Shade] Boson", "ResourcesDirectoryLocator");
    private final String targetDirectory;
    private final Kind kind;
    private final List<AutoCloseable> walkStack = new ArrayList<AutoCloseable>();
    private final Lazy<List<Lazy<Location>>> lazyLocations;

    private ResourcesDirectoryLocator(@Nonnull String targetDirectory, @Nonnull Kind kind) {
        this.targetDirectory = Objects.requireNonNull(targetDirectory);
        this.kind = Objects.requireNonNull(kind);
        this.lazyLocations = Lazy.lazy(() -> {
            LOG.info("Attempting to load data from the 'resources/' directory, situated in your main game directory");
            LOG.info("We are currently looking in the '" + this.targetDirectory + "' directory with kind " + (Object)((Object)this.kind));
            return this.scanResourcesDirectory(Paths.get(".", new String[0]).resolve("./resources").normalize().toAbsolutePath());
        });
    }

    @Nonnull
    public static ResourcesDirectoryLocator create(@Nonnull String targetDirectory, @Nonnull Kind kind) {
        return new ResourcesDirectoryLocator(targetDirectory, kind);
    }

    @Nonnull
    public static ResourcesDirectoryLocator create(@Nonnull String targetDirectory) {
        return ResourcesDirectoryLocator.create(targetDirectory, Kind.DATA);
    }

    @Override
    @Nonnull
    public List<Lazy<Location>> getLocations() {
        return this.lazyLocations.invoke();
    }

    @Nonnull
    private List<Lazy<Location>> scanResourcesDirectory(@Nonnull Path resources) {
        return this.scanAllDirectories(resources.resolve("./" + this.kind.directoryName + "/").normalize().toAbsolutePath(), resources);
    }

    @Nonnull
    private List<Lazy<Location>> scanAllDirectories(@Nonnull Path data, @Nonnull Path resources) {
        return IfExpression.build(Files.exists(data, new LinkOption[0]), () -> {
            try {
                return this.addToWalkStack(Files.walk(data, 1, new FileVisitOption[0])).filter(it -> !it.getParent().getFileName().toString().endsWith("resources")).flatMap(it -> this.scanDirectory((Path)it, resources)).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw CheckedException.wrap(e);
            }
        }, () -> {
            LOG.info("Directory '" + data + "' does not exist: skipping resource loading");
            return new ArrayList();
        }).invoke();
    }

    @Nonnull
    private Stream<Lazy<Location>> scanDirectory(@Nonnull Path id, @Nonnull Path resources) {
        return this.scanForFiles(id.resolve("./" + this.targetDirectory).normalize().toAbsolutePath(), id, resources);
    }

    @Nonnull
    private Stream<Lazy<Location>> scanForFiles(@Nonnull Path target, @Nonnull Path id, @Nonnull Path resources) {
        String modId = id.getFileName().toString();
        if (!Files.exists(target, new LinkOption[0])) {
            LOG.warn("Directory '" + resources.relativize(target) + "' doesn't exist: skipping loading of files");
        } else {
            LOG.info("Successfully identified directory '" + resources.relativize(target) + "': proceeding with loading of files");
        }
        return Stream.of(Lazy.lazy(() -> {
            BaseContext context = BaseContext.create();
            context.set(CCK.MOD_ID_CONTEXT_KEY.invoke(), modId);
            return BaseLocation.create(target.toAbsolutePath(), Nullable.get(modId + " - User-Added Resources"), Nullable.get(context));
        }));
    }

    @Override
    @Nonnull
    public Unit clean() {
        ResourcesDirectoryLocator.reversed(this.walkStack).forEach(it -> {
            try {
                it.close();
            }
            catch (Exception e) {
                throw CheckedException.wrap(e);
            }
        });
        return Locator.super.clean();
    }

    @Nonnull
    private <T extends AutoCloseable> T addToWalkStack(@Nonnull T t) {
        this.walkStack.add(t);
        return t;
    }

    @Nonnull
    private static <T> List<T> reversed(@Nonnull List<T> $this$receiver) {
        return IfExpression.build($this$receiver.size() <= 1, () -> $this$receiver, () -> {
            ArrayList copy = new ArrayList($this$receiver);
            ResourcesDirectoryLocator.reverse(copy);
            return copy;
        }).invoke();
    }

    @Nonnull
    private static <T> Unit reverse(@Nonnull List<T> $this$receiver) {
        Collections.reverse($this$receiver);
        return Unit.UNIT;
    }

    public static enum Kind {
        ASSETS("assets"),
        DATA("data");

        private final String directoryName;

        private Kind(String directoryName) {
            this.directoryName = directoryName;
        }
    }
}

