/*
 * Decompiled with CFR 0.152.
 */
package com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.prefab.loader.progress;

import com.aaronhowser1.dymm.L;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Nullable;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.Unit;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.AssertNotNullExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.kotlin.bridge.expression.ElvisExpression;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.id.NameSpacedString;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.LoadingPhase;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.Location;
import com.aaronhowser1.dymm.shade.net.thesilkminer.mc.boson.api.loader.ProgressVisitor;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.common.ProgressManager;

public final class ProgressBarVisitor
implements ProgressVisitor {
    private final L l = L.create("[DYMM Shade] Boson", "Progress Bar Visitor");
    private Nullable<ProgressManager.ProgressBar> bar = Nullable.get(null);
    private Nullable<String> nextPhase = Nullable.get(null);

    @Override
    @Nonnull
    public Unit beginVisit() {
        return Unit.UNIT;
    }

    @Override
    @Nonnull
    public Unit visitPhases(int total) {
        this.l.debug(total + " phases to go through");
        return Unit.UNIT;
    }

    @Override
    @Nonnull
    public Unit visitPhase(@Nonnull LoadingPhase<?> phase) {
        this.endVisit();
        this.l.debug("Preparing to push new bar for phase '" + phase.getName() + "'");
        this.nextPhase = Nullable.get(phase.getName());
        return Unit.UNIT;
    }

    @Override
    @Nonnull
    public Unit visitItemsTotal(int total) {
        this.l.debug("Pushing bar");
        this.bar = Nullable.get(ProgressManager.push((String)this.nextPhase.unwrap(), (int)total));
        this.nextPhase = Nullable.get(null);
        return Unit.UNIT;
    }

    @Override
    @Nonnull
    public Unit visitLocation(@Nonnull Location location, boolean isDirectory) {
        this.l.debug("Step for path " + location.getFriendlyName());
        return (Unit)((Object)AssertNotNullExpression.create(this.bar.ifPresent(it -> {
            it.step(location.getFriendlyName().unwrap());
            return Unit.UNIT;
        })).invoke());
    }

    @Override
    @Nonnull
    public Unit visitItems(int amount) {
        return Unit.UNIT;
    }

    @Override
    @Nonnull
    public Unit visitItem(@Nonnull NameSpacedString name) {
        return Unit.UNIT;
    }

    @Override
    @Nonnull
    public Unit endVisit() {
        return ElvisExpression.create(this.bar.ifPresent(it -> {
            this.l.debug("Popping bar '" + it + "'");
            ProgressManager.pop((ProgressManager.ProgressBar)it);
            return Unit.UNIT;
        }), () -> Unit.UNIT).invoke();
    }
}

