/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.animation;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.minelittlepony.common.util.animation.Interpolator;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;

public class LinearInterpolator
implements Interpolator {
    static LoadingCache<UUID, LinearInterpolator> instanceCache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).build(CacheLoader.from(LinearInterpolator::new));
    private final Map<String, Float> properties = new HashMap<String, Float>();

    @Override
    public float interpolate(String key, float to, float animationSpeed) {
        float from = this.properties.getOrDefault(key, Float.valueOf(to)).floatValue();
        if (Float.isNaN(from += (to - from) / animationSpeed) || Float.isInfinite(from)) {
            System.err.println("Error: Animation frame for " + key + " is NaN or Infinite.");
            from = to;
        }
        this.properties.put(key, Float.valueOf(from));
        return from;
    }
}

