/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.common.util.settings;

import java.nio.file.Path;
import java.util.Arrays;
import java.util.stream.Stream;

public interface FileUtils {
    public static final char FILE_PATH_EXTENSION_SEPARATOR = '.';
    public static final String FILE_PATH_EXTENSION_REG = "\\.";

    public static String getFileExtension(Path path) {
        String[] pair = path.getFileName().toString().split(FILE_PATH_EXTENSION_REG);
        return pair.length > 1 ? pair[1].trim() : "";
    }

    public static Stream<Path> getAlternatives(Path path, String[] supportedExtensions) {
        return Arrays.stream(supportedExtensions).map(ext -> FileUtils.changeExtension(path, ext));
    }

    public static Path changeExtension(Path path, String newExtension) {
        String extension = FileUtils.getFileExtension(path);
        String sPath = path.toString();
        if (!extension.isBlank()) {
            sPath = sPath.substring(0, sPath.length() - extension.length() - 1);
        }
        return Path.of(sPath + "." + newExtension, new String[0]);
    }
}

