/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.impl;

import com.sollace.fabwork.api.ModEntry;
import com.sollace.fabwork.api.client.FabworkClient;
import com.sollace.fabwork.api.client.ModProvisionCallback;
import com.sollace.fabwork.impl.ConsentMessage;
import com.sollace.fabwork.impl.Debug;
import com.sollace.fabwork.impl.FabworkConfig;
import com.sollace.fabwork.impl.FabworkImpl;
import com.sollace.fabwork.impl.LoaderUtil;
import com.sollace.fabwork.impl.ModEntriesUtil;
import com.sollace.fabwork.impl.ModEntryImpl;
import com.sollace.fabwork.impl.SynchronisationState;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2661;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabworkClientImpl
implements ClientModInitializer {
    private static final Logger LOGGER = LogManager.getLogger((String)"Fabwork::CLIENT");
    private static final SynchronisationState EMPTY_STATE;
    private static SynchronisationState STATE;
    public static final FabworkClient INSTANCE;

    public void onInitializeClient() {
        if (Debug.NO_CLIENT) {
            return;
        }
        if (!FabworkConfig.INSTANCE.get().disableLoginProtocol) {
            ClientConfigurationConnectionEvents.INIT.register((handler, client) -> LoaderUtil.invokeUntrusted(() -> {
                STATE.installedOnServer().forEach(entry -> ((ModProvisionCallback)ModProvisionCallback.EVENT.invoker()).onModProvisioned((ModEntry)entry, false));
                STATE = EMPTY_STATE;
            }, "Client connection init"));
            ClientConfigurationNetworking.registerGlobalReceiver(ConsentMessage.ID, (payload, context) -> LoaderUtil.invokeUntrusted(() -> {
                STATE = new SynchronisationState(FabworkImpl.INSTANCE.getInstalledMods(), payload.entries().stream());
                LOGGER.info("Got mod list from server: {}", (Object)ModEntriesUtil.stringify(STATE.installedOnServer()));
                Set serverModIds = STATE.installedOnServer().stream().map(ModEntryImpl::modId).distinct().collect(Collectors.toSet());
                context.responseSender().sendPacket((class_8710)new ConsentMessage(FabworkImpl.INSTANCE.getInstalledMods().filter(entry -> entry.requiredOnEither() || serverModIds.contains(entry.modId())).toList()));
            }, "Responding to server sync packet"));
            ClientConfigurationConnectionEvents.READY.register((handler, client) -> LoaderUtil.invokeUntrusted(() -> STATE.verify(LOGGER, true).ifPresent(disconnectReason -> handler.method_52781(new class_2661(disconnectReason))), "Entering play state"));
        }
        LoaderUtil.invokeEntryPoints("fabwork:client", ClientModInitializer.class, ClientModInitializer::onInitializeClient);
        LOGGER.info("Loaded Fabwork {}", (Object)((ModContainer)FabricLoader.getInstance().getModContainer("fabwork").get()).getMetadata().getVersion().getFriendlyString());
    }

    static {
        STATE = EMPTY_STATE = new SynchronisationState(FabworkImpl.INSTANCE.getInstalledMods(), Stream.empty());
        INSTANCE = () -> STATE.installedOnServer().stream();
    }
}

