/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.impl;

import com.google.common.base.Suppliers;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import com.sollace.fabwork.api.RequirementType;
import com.sollace.fabwork.impl.ModEntryImpl;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.Nullable;

class FabworkConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static final Supplier<FabworkConfig> INSTANCE = Suppliers.memoize(() -> FabworkConfig.load(FabricLoader.getInstance().getConfigDir().resolve("fabwork.json")));
    @Nullable
    public List<String> requiredModIds;
    public boolean doNotEnforceModMatching;
    public boolean disableLoginProtocol;
    public boolean allowUnmoddedClients;

    FabworkConfig() {
    }

    public static FabworkConfig load(Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            FabworkConfig fabworkConfig;
            block11: {
                BufferedReader reader = Files.newBufferedReader(path);
                try {
                    fabworkConfig = FabworkConfig.save((FabworkConfig)GSON.fromJson((Reader)reader, FabworkConfig.class), path);
                    if (reader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JsonParseException | IOException e) {
                        try {
                            Files.deleteIfExists(path);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                reader.close();
            }
            return fabworkConfig;
        }
        return FabworkConfig.save(new FabworkConfig(), path);
    }

    @Nullable
    private static FabworkConfig save(@Nullable FabworkConfig config, Path path) {
        if (config == null) {
            return config;
        }
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return config;
    }

    public Stream<ModEntryImpl> getCustomRequiredMods() {
        if (this.requiredModIds == null || this.requiredModIds.isEmpty()) {
            return Stream.empty();
        }
        return this.requiredModIds.stream().filter(Objects::nonNull).distinct().map(id -> new ModEntryImpl((String)id, RequirementType.CLIENT));
    }
}

