/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.impl;

import com.google.common.collect.Streams;
import com.sollace.fabwork.api.Fabwork;
import com.sollace.fabwork.impl.ClientConnectionAccessor;
import com.sollace.fabwork.impl.ConsentMessage;
import com.sollace.fabwork.impl.Debug;
import com.sollace.fabwork.impl.FabworkConfig;
import com.sollace.fabwork.impl.FabworkImpl;
import com.sollace.fabwork.impl.LoaderUtil;
import com.sollace.fabwork.impl.ModEntriesUtil;
import com.sollace.fabwork.impl.ModEntryImpl;
import com.sollace.fabwork.impl.SynchronisationState;
import java.util.HashMap;
import java.util.function.Consumer;
import java.util.stream.Stream;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerConfigurationNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_2535;
import net.minecraft.class_2596;
import net.minecraft.class_8605;
import net.minecraft.class_8609;
import net.minecraft.class_8610;
import net.minecraft.class_8710;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FabworkServer
implements ModInitializer {
    public static final Logger LOGGER = LogManager.getLogger((String)"Fabwork::SERVER");
    public static final class_8605.class_8606 MOD_LIST_SYNC_TASK = new class_8605.class_8606(ConsentMessage.ID.comp_2242().toString());
    public static final int PROTOCOL_VERSION = 1;
    public static final Fabwork FABWORK = FabworkImpl.INSTANCE;

    public void onInitialize() {
        if (Debug.NO_SERVER) {
            return;
        }
        PayloadTypeRegistry.configurationS2C().register(ConsentMessage.ID, ConsentMessage.CODEC);
        PayloadTypeRegistry.configurationC2S().register(ConsentMessage.ID, ConsentMessage.CODEC);
        FabworkConfig config = FabworkConfig.INSTANCE.get();
        final SynchronisationState emptyState = new SynchronisationState(Stream.empty(), FabworkServer.makeDistinct(Streams.concat((Stream[])new Stream[]{FabworkImpl.INSTANCE.getInstalledMods().filter(ModEntryImpl::requiredOnEither), config.getCustomRequiredMods()})));
        if (!config.disableLoginProtocol) {
            ServerConfigurationConnectionEvents.CONFIGURE.register((handler, server) -> {
                final class_2535 connection = ClientConnectionAccessor.get((class_8609)handler);
                if (ServerConfigurationNetworking.canSend((class_8610)handler, ConsentMessage.ID)) {
                    handler.addTask(new class_8605(){

                        public void method_52376(Consumer<class_2596<?>> sender) {
                            LOGGER.info("Sending mod list to {}[{}]", (Object)handler.method_52404().getName(), (Object)connection.method_10755());
                            sender.accept(ServerConfigurationNetworking.createS2CPacket((class_8710)new ConsentMessage(emptyState.installedOnServer())));
                        }

                        public class_8605.class_8606 method_52375() {
                            return MOD_LIST_SYNC_TASK;
                        }
                    });
                } else {
                    LOGGER.warn("{}[{}] does not appear to have fabwork installed", (Object)handler.method_52404().getName(), (Object)connection.method_10755());
                    if (config.allowUnmoddedClients) {
                        LOGGER.warn("Connection to {}[{}] has been force permitted by server configuration. They are allowed to join checking installed mods! Their game may be broken upon joining!", (Object)handler.method_52404().getName(), (Object)connection.method_10755());
                    } else {
                        emptyState.verify(LOGGER, false).ifPresent(arg_0 -> ((class_8610)handler).method_52396(arg_0));
                    }
                }
            });
            ServerConfigurationNetworking.registerGlobalReceiver(ConsentMessage.ID, (payload, context) -> LoaderUtil.invokeUntrusted(() -> {
                SynchronisationState state = new SynchronisationState(payload.entries().stream(), emptyState.installedOnServer().stream());
                class_2535 connection = ClientConnectionAccessor.get((class_8609)context.networkHandler());
                LOGGER.info("Got mod list from {}[{}]: {}", (Object)context.networkHandler().method_52404().getName(), (Object)connection.method_10755(), (Object)ModEntriesUtil.stringify(state.installedOnClient()));
                state.verify(LOGGER, true).ifPresentOrElse(arg_0 -> ((class_8610)context.networkHandler()).method_52396(arg_0), () -> context.networkHandler().completeTask(MOD_LIST_SYNC_TASK));
            }, "Received synchronize response from client"));
        }
        LoaderUtil.invokeEntryPoints("fabwork:main", ModInitializer.class, ModInitializer::onInitialize);
        LOGGER.info("Loaded Fabwork " + ((ModContainer)FabricLoader.getInstance().getModContainer("fabwork").get()).getMetadata().getVersion().getFriendlyString());
    }

    private static Stream<ModEntryImpl> makeDistinct(Stream<ModEntryImpl> entries) {
        HashMap map = new HashMap();
        entries.forEach(entry -> map.compute(entry.modId(), (id, value) -> value == null || entry.requirement().supercedes(value.requirement()) ? entry : value));
        return map.values().stream();
    }
}

