/*
 * Decompiled with CFR 0.152.
 */
package com.sollace.fabwork.impl;

import com.sollace.fabwork.api.ModEntry;
import com.sollace.fabwork.api.client.ModProvisionCallback;
import com.sollace.fabwork.impl.FabworkConfig;
import com.sollace.fabwork.impl.ModEntriesUtil;
import com.sollace.fabwork.impl.ModEntryImpl;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import org.apache.logging.log4j.Logger;

record SynchronisationState(List<ModEntryImpl> installedOnClient, List<ModEntryImpl> installedOnServer) {
    public SynchronisationState(Stream<ModEntryImpl> installedOnClient, Stream<ModEntryImpl> installedOnServer) {
        this(installedOnClient.toList(), installedOnServer.toList());
    }

    public Optional<class_2561> verify(Logger logger, boolean useTranslation) {
        Set<String> missingOnServer = ModEntriesUtil.compare(this.installedOnClient.stream().filter(c -> c.requirement().isRequiredOnServer()), this.installedOnServer);
        Set<String> missingOnClient = ModEntriesUtil.compare(this.installedOnServer.stream().filter(c -> c.requirement().isRequiredOnClient()), this.installedOnClient);
        this.installedOnServer.stream().forEach(entry -> ((ModProvisionCallback)ModProvisionCallback.EVENT.invoker()).onModProvisioned((ModEntry)entry, !missingOnClient.contains(entry.modId())));
        if (!missingOnServer.isEmpty() || !missingOnClient.isEmpty()) {
            class_2561 errorMessage = this.createErrorMessage(missingOnServer, missingOnClient, useTranslation);
            logger.error(errorMessage.getString());
            if (FabworkConfig.INSTANCE.get().doNotEnforceModMatching) {
                logger.info("Connection would fail with message '{}' but was allowed anyway due to configured rules.", (Object)errorMessage.toString());
                return Optional.empty();
            }
            return Optional.of(errorMessage);
        }
        CharSequence[] installed = (String[])this.installedOnServer.stream().map(ModEntry::modId).toArray(String[]::new);
        logger.info("Connection succeeded with {} syncronised mod(s) [{}]", (Object)installed.length, (Object)String.join((CharSequence)", ", installed));
        return Optional.empty();
    }

    private class_2561 createErrorMessage(Set<String> missingOnServer, Set<String> missingOnClient, boolean useTranslation) {
        String serverMissing = String.join((CharSequence)", ", (CharSequence[])missingOnServer.stream().toArray(CharSequence[]::new));
        String clientMissing = String.join((CharSequence)", ", (CharSequence[])missingOnClient.stream().toArray(CharSequence[]::new));
        if (missingOnClient.isEmpty()) {
            return class_2561.method_43469((String)(useTranslation ? "fabwork.error.server_missing_mods" : "Server is missing required mod(s). Remove these from your client to join this server. [%s]"), (Object[])new Object[]{serverMissing});
        }
        if (missingOnServer.isEmpty()) {
            return class_2561.method_43469((String)(useTranslation ? "fabwork.error.client_missing_mods" : "Client is missing required mod(s). Add these to your client to join this server. [%s]"), (Object[])new Object[]{clientMissing});
        }
        return class_2561.method_43469((String)(useTranslation ? "fabwork.error.both_missing_mods" : "Client and Server are missing required mod(s). Client needs to install [%s] and remove [%s] in order to join this server."), (Object[])new Object[]{clientMissing, serverMissing});
    }
}

