/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api;

import java.net.InetAddress;
import java.util.Objects;
import space.arim.libertybans.api.NetworkAddress;
import space.arim.libertybans.api.Victim;

public final class AddressVictim
extends Victim {
    private final NetworkAddress address;

    private AddressVictim(NetworkAddress address) {
        this.address = Objects.requireNonNull(address, "address");
    }

    public static AddressVictim of(NetworkAddress address) {
        return new AddressVictim(address);
    }

    public static AddressVictim of(InetAddress address) {
        return new AddressVictim(NetworkAddress.of(address));
    }

    public static AddressVictim of(byte[] address) {
        return new AddressVictim(NetworkAddress.of(address));
    }

    @Override
    public Victim.VictimType getType() {
        return Victim.VictimType.ADDRESS;
    }

    public NetworkAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressVictim that = (AddressVictim)o;
        return this.address.equals(that.address);
    }

    @Override
    public int hashCode() {
        return this.address.hashCode();
    }

    @Override
    public String toString() {
        return "AddressVictim{address=" + String.valueOf(this.address) + "}";
    }
}

