/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api;

import java.net.InetAddress;
import java.util.Objects;
import java.util.UUID;
import space.arim.libertybans.api.NetworkAddress;
import space.arim.libertybans.api.Victim;

public final class CompositeVictim
extends Victim {
    private final UUID uuid;
    private final NetworkAddress address;
    public static final UUID WILDCARD_UUID = new UUID(0L, 0L);
    public static final NetworkAddress WILDCARD_ADDRESS = NetworkAddress.of(new byte[4]);

    private CompositeVictim(UUID uuid, NetworkAddress address) {
        this.uuid = Objects.requireNonNull(uuid, "uuid");
        this.address = Objects.requireNonNull(address, "address");
    }

    public static CompositeVictim of(UUID uuid, NetworkAddress address) {
        return new CompositeVictim(uuid, address);
    }

    public static CompositeVictim of(UUID uuid, InetAddress address) {
        return new CompositeVictim(uuid, NetworkAddress.of(address));
    }

    public static CompositeVictim of(UUID uuid, byte[] address) {
        return new CompositeVictim(uuid, NetworkAddress.of(address));
    }

    @Override
    public Victim.VictimType getType() {
        return Victim.VictimType.COMPOSITE;
    }

    public UUID getUUID() {
        return this.uuid;
    }

    public NetworkAddress getAddress() {
        return this.address;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CompositeVictim that = (CompositeVictim)o;
        return this.uuid.equals(that.uuid) && this.address.equals(that.address);
    }

    @Override
    public int hashCode() {
        int result = this.uuid.hashCode();
        result = 31 * result + this.address.hashCode();
        return result;
    }

    @Override
    public String toString() {
        return "CompositeVictim{uuid=" + String.valueOf(this.uuid) + ", address=" + String.valueOf(this.address) + "}";
    }
}

