/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api.punish;

import java.util.Objects;

public final class EscalationTrack {
    public static final String DEFAULT_NAMESPACE = "default";
    private final String namespace;
    private final String value;

    private EscalationTrack(String namespace, String value) {
        if (namespace.contains(":") || value.contains(":")) {
            throw new IllegalArgumentException("Neither namespace nor value may contain colons");
        }
        this.namespace = Objects.requireNonNull(namespace, "namespace");
        this.value = Objects.requireNonNull(value, "value");
    }

    public static EscalationTrack create(String namespace, String value) {
        return new EscalationTrack(namespace, value);
    }

    public static EscalationTrack createDefault(String value) {
        return EscalationTrack.create(DEFAULT_NAMESPACE, value);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EscalationTrack that = (EscalationTrack)o;
        return this.namespace.equals(that.namespace) && this.value.equals(that.value);
    }

    public int hashCode() {
        int result = this.namespace.hashCode();
        result = 31 * result + this.value.hashCode();
        return result;
    }

    public String toString() {
        return "EscalationTrack{namespace='" + this.namespace + "', value='" + this.value + "'}";
    }
}

