/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.api.punish;

import java.time.Clock;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Consumer;
import space.arim.libertybans.api.punish.EnforcementOptions;
import space.arim.libertybans.api.punish.EnforcementOptionsFactory;
import space.arim.libertybans.api.punish.PunishmentBase;
import space.arim.libertybans.api.punish.PunishmentEditor;
import space.arim.omnibus.util.concurrent.ReactionStage;

public interface Punishment
extends PunishmentBase,
EnforcementOptionsFactory {
    public static final Instant PERMANENT_END_DATE = Instant.MAX;

    @Deprecated
    default public int getID() {
        return (int)this.getIdentifier();
    }

    public long getIdentifier();

    public Instant getStartDate();

    default public long getStartDateSeconds() {
        return this.getStartDate().getEpochSecond();
    }

    public Instant getEndDate();

    default public long getEndDateSeconds() {
        Instant endDate = this.getEndDate();
        return endDate.equals(PERMANENT_END_DATE) ? 0L : endDate.getEpochSecond();
    }

    default public boolean isPermanent() {
        return PERMANENT_END_DATE.equals(this.getEndDate());
    }

    default public boolean isTemporary() {
        return !this.isPermanent();
    }

    default public boolean isExpired() {
        if (this.isPermanent()) {
            return false;
        }
        return Instant.now().compareTo(this.getEndDate()) > 0;
    }

    default public boolean isExpired(Clock clock) {
        if (this.isPermanent()) {
            return false;
        }
        return clock.instant().compareTo(this.getEndDate()) > 0;
    }

    default public ReactionStage<?> enforcePunishment() {
        return this.enforcePunishment(this.enforcementOptionsBuilder().build());
    }

    public ReactionStage<?> enforcePunishment(EnforcementOptions var1);

    default public ReactionStage<Boolean> undoPunishment() {
        return this.undoPunishment(this.enforcementOptionsBuilder().build());
    }

    public ReactionStage<Boolean> undoPunishment(EnforcementOptions var1);

    default public ReactionStage<?> unenforcePunishment() {
        return this.unenforcePunishment(this.enforcementOptionsBuilder().build());
    }

    public ReactionStage<?> unenforcePunishment(EnforcementOptions var1);

    public ReactionStage<Optional<Punishment>> modifyPunishment(Consumer<PunishmentEditor> var1);

    public boolean equals(Object var1);
}

