/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import space.arim.libertybans.bootstrap.CulpritFinder;
import space.arim.libertybans.bootstrap.DependencyBundle;
import space.arim.libertybans.bootstrap.DistributionMode;
import space.arim.libertybans.bootstrap.Payload;
import space.arim.libertybans.bootstrap.Platform;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.bootstrap.classload.AttachableClassLoader;
import space.arim.libertybans.bootstrap.classload.ClassLoadGuard;
import space.arim.libertybans.bootstrap.classload.LibraryProtection;
import space.arim.libertybans.bootstrap.classload.RuntimeExceptionCatcher;
import space.arim.libertybans.bootstrap.depend.BootstrapLauncher;
import space.arim.libertybans.bootstrap.depend.DependencyLoaderBuilder;
import space.arim.libertybans.bootstrap.depend.ExistingDependency;
import space.arim.libertybans.bootstrap.logger.BootstrapLogger;

public final class LibertyBansLauncher {
    private final Path folder;
    private final BootstrapLogger logger;
    private final Platform platform;
    private final Executor executor;
    private final CulpritFinder culpritFinder;
    private final DistributionMode distributionMode;
    private final ClassLoader parentLoader;

    private LibertyBansLauncher(Path folder, BootstrapLogger logger, Platform platform, Executor executor, CulpritFinder culpritFinder, DistributionMode distributionMode, ClassLoader parentLoader) {
        this.folder = Objects.requireNonNull(folder, "folder");
        this.logger = Objects.requireNonNull(logger, "logger");
        this.platform = Objects.requireNonNull(platform, "platform");
        this.executor = Objects.requireNonNull(executor, "executor");
        this.culpritFinder = Objects.requireNonNull(culpritFinder, "culpritFinder");
        this.distributionMode = Objects.requireNonNull(distributionMode, "distributionMode");
        this.parentLoader = Objects.requireNonNull(parentLoader, "parentLoader");
    }

    public <P> Payload<P> getPayload(P plugin) {
        return new Payload<P>(plugin, this.platform.platformId, this.folder);
    }

    public <P> Payload<P> getPayloadWith(P plugin, List<Object> attachments) {
        return new Payload<P>(plugin, this.platform.platformId, this.folder, attachments);
    }

    private void filterLibrariesAndWarnRelocation(Set<ProtectedLibrary> librariesRequiringProtection) {
        StringJoiner collectedDetails = new StringJoiner("\n");
        Iterator<ProtectedLibrary> iterator = librariesRequiringProtection.iterator();
        while (iterator.hasNext()) {
            Class<?> libClass;
            ProtectedLibrary library = iterator.next();
            try {
                libClass = Class.forName(library.sampleClass());
            }
            catch (ClassNotFoundException ignored) {
                iterator.remove();
                continue;
            }
            if (library == ProtectedLibrary.HIKARICP && this.platform.hasHiddenHikariCP()) continue;
            if (library == ProtectedLibrary.JAKARTA_INJECT) {
                this.logger.info("Library " + library.libraryName() + " already provided by another plugin");
                continue;
            }
            String pluginName = this.culpritFinder.findCulprit(libClass).map(name -> "Plugin '" + name + "'").orElse("<Unknown>");
            collectedDetails.add(pluginName + " | " + library.libraryName() + " | " + libClass.getName());
        }
        if (collectedDetails.length() == 0) {
            return;
        }
        if (Boolean.getBoolean("libertybans.relocationbug.disablecheck")) {
            this.logger.info("Discovered unrelocated classes: \n" + String.valueOf(collectedDetails));
            return;
        }
        String line = "*******************************************";
        this.logger.warn(line + "\nWe detected bugs on your server which threaten its stability.\nLibertyBans will continue to operate unaffected, but we strongly suggest you fix these bugs.\n\nWe detected the following plugins with unrelocated library classes.\n\nPlugin Name | Library Name | Class Detected\n----------------------------------------------\n" + String.valueOf(collectedDetails) + "\n\nFor advanced users, you can minimize this warning by setting the system property libertybans.relocationbug.disablecheck to 'true'\n" + line);
    }

    private Set<DependencyBundle> determineNeededDependencies(Set<ProtectedLibrary> librariesRequiringProtection) {
        EnumSet<DependencyBundle> bundles = EnumSet.noneOf(DependencyBundle.class);
        for (DependencyBundle bundle : DependencyBundle.values()) {
            if (this.platform.isBundleProvided(bundle)) {
                librariesRequiringProtection.removeAll(bundle.protectedLibraries());
                continue;
            }
            bundles.add(bundle);
        }
        return bundles;
    }

    private void migrateLegacyDirectory(Path oldPath, Path newPath) throws IOException {
        if (Files.exists(oldPath, new LinkOption[0]) && !Files.isDirectory(newPath, new LinkOption[0])) {
            Files.move(oldPath, newPath, new CopyOption[0]);
            this.logger.info("Migrated legacy directory " + String.valueOf(oldPath) + " to " + String.valueOf(newPath) + ".");
        }
    }

    private void migrateLegacyDirectories(Path internalFolder) {
        Path newHyperSqlFolder = internalFolder.resolve("hypersql");
        Path newLibrariesFolder = internalFolder.resolve("libraries");
        try {
            Files.createDirectories(internalFolder, new FileAttribute[0]);
            this.migrateLegacyDirectory(this.folder.resolve("hypersql"), newHyperSqlFolder);
            this.migrateLegacyDirectory(this.folder.resolve("libraries"), newLibrariesFolder);
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    public CompletableFuture<ClassLoader> attemptLaunch() {
        Set additionalLibraries;
        Path internalFolder = this.folder.resolve("internal");
        this.migrateLegacyDirectories(internalFolder);
        EnumSet<ProtectedLibrary> librariesRequiringProtection = EnumSet.allOf(ProtectedLibrary.class);
        HashSet<ExistingDependency> existingDependencies = new HashSet<ExistingDependency>();
        DependencyLoaderBuilder loader = new DependencyLoaderBuilder().executor(this.executor).outputDirectory(internalFolder.resolve("libraries"));
        block22: for (DependencyBundle bundle : this.determineNeededDependencies(librariesRequiringProtection)) {
            switch (this.distributionMode) {
                case TESTING: {
                    if (bundle == DependencyBundle.SELF_IMPLEMENTATION) continue block22;
                    bundle.prepareToDownload(loader);
                    continue block22;
                }
                case DEPLOY_AND_DOWNLOAD: {
                    bundle.prepareToDownload(loader);
                    continue block22;
                }
                case JAR_OF_JARS: {
                    existingDependencies.add(bundle.existingDependency());
                    continue block22;
                }
            }
            throw new IllegalArgumentException("Unknown distributionMode " + String.valueOf((Object)this.distributionMode));
        }
        this.filterLibrariesAndWarnRelocation(librariesRequiringProtection);
        ClassLoadGuard guard = ClassLoadGuard.passThrough();
        if (!librariesRequiringProtection.isEmpty()) {
            guard = new LibraryProtection(librariesRequiringProtection, guard);
        }
        if (this.platform.category == Platform.Category.BUKKIT) {
            guard = new RuntimeExceptionCatcher(this.logger, internalFolder, guard);
        }
        BootstrapLauncher<AttachableClassLoader> launcher = new BootstrapLauncher<AttachableClassLoader>(guard.makeClassLoader("LibertyBans-ClassLoader", this.parentLoader), loader.build(), existingDependencies);
        CompletableFuture<AttachableClassLoader> futureClassLoader = launcher.load();
        try {
            boolean versionChanged;
            Path storeVersionAt = internalFolder.resolve("last_known_version");
            String currentVersion = "1.1.1";
            String lastVersion = null;
            if (Files.exists(storeVersionAt, new LinkOption[0])) {
                lastVersion = Files.readString(storeVersionAt, StandardCharsets.UTF_8);
            }
            boolean bl = versionChanged = !currentVersion.equals(lastVersion);
            if (versionChanged) {
                Files.writeString(storeVersionAt, (CharSequence)currentVersion, StandardCharsets.UTF_8, new OpenOption[0]);
                this.logger.info("Updated recorded version at " + String.valueOf(storeVersionAt));
            }
            Path addonsFolder = this.folder.resolve("addons");
            Files.createDirectories(addonsFolder, new FileAttribute[0]);
            try (Stream<Path> addonStream = Files.list(addonsFolder);){
                Set addonJars = addonStream.filter(library -> library.getFileName().toString().endsWith(".jar")).collect(Collectors.toCollection(HashSet::new));
                if (versionChanged || "1.1.1".contains("SNAPSHOT")) {
                    for (Path addonJar : addonJars) {
                        String addonName = addonJar.getFileName().toString();
                        URL jarResource = this.getClass().getResource("/dependencies/addon-jars/" + addonName);
                        if (jarResource == null) continue;
                        try (InputStream resourceInput = jarResource.openStream();){
                            Files.copy(resourceInput, addonJar, StandardCopyOption.REPLACE_EXISTING);
                        }
                    }
                }
                this.logger.info((String)(addonJars.isEmpty() ? "No addons detected" : "Detected " + addonJars.size() + " addon(s)"));
                additionalLibraries = addonJars;
            }
            Path attachmentsFolder = internalFolder.resolve("attachments");
            Files.createDirectories(attachmentsFolder, new FileAttribute[0]);
            try (Stream<Path> attachments = Files.list(attachmentsFolder);){
                attachments.forEach(additionalLibraries::add);
            }
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
        return futureClassLoader.thenApply(classLoader -> {
            additionalLibraries.forEach(classLoader::addJarPath);
            return classLoader;
        });
    }

    public static final class FinalStep {
        private final Step2 step2;
        private final Executor executor;
        private CulpritFinder culpritFinder;
        private DistributionMode distributionMode;
        private ClassLoader parentLoader;

        private FinalStep(Step2 step2, Executor executor) {
            this.step2 = step2;
            this.executor = executor;
        }

        public FinalStep culpritFinder(CulpritFinder culpritFinder) {
            this.culpritFinder = culpritFinder;
            return this;
        }

        public FinalStep distributionMode(DistributionMode distributionMode) {
            this.distributionMode = distributionMode;
            return this;
        }

        public FinalStep parentLoader(ClassLoader parentLoader) {
            this.parentLoader = parentLoader;
            return this;
        }

        public LibertyBansLauncher build() {
            CulpritFinder culpritFinder = Objects.requireNonNullElse(this.culpritFinder, clazz -> Optional.empty());
            DistributionMode distributionMode = Objects.requireNonNullElseGet(this.distributionMode, () -> {
                if (this.getClass().getResource("/bans-executable_identifier") != null) {
                    return DistributionMode.JAR_OF_JARS;
                }
                return DistributionMode.DEPLOY_AND_DOWNLOAD;
            });
            ClassLoader parentLoader = Objects.requireNonNullElse(this.parentLoader, this.getClass().getClassLoader());
            Step1 step1 = this.step2.step1;
            return new LibertyBansLauncher(step1.folder, step1.logger, this.step2.platform.build(step1.logger), this.executor, culpritFinder, distributionMode, parentLoader);
        }
    }

    public static final class Step2 {
        private final Step1 step1;
        private final Platform.Builder platform;

        private Step2(Step1 step1, Platform.Builder platform) {
            this.step1 = step1;
            this.platform = platform;
        }

        public FinalStep executor(Executor executor) {
            return new FinalStep(this, executor);
        }
    }

    public static final class Step1 {
        private final Path folder;
        private final BootstrapLogger logger;

        private Step1(Path folder, BootstrapLogger logger) {
            this.folder = folder;
            this.logger = logger;
        }

        public Step2 platform(Platform.Builder platform) {
            return new Step2(this, platform);
        }
    }

    public static final class Step0 {
        private final Path folder;

        private Step0(Path folder) {
            this.folder = folder;
        }

        public Step1 logger(BootstrapLogger logger) {
            return new Step1(this.folder, logger);
        }
    }

    public static final class Builder {
        public Step0 folder(Path folder) {
            return new Step0(folder);
        }
    }
}

