/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap;

import java.util.Objects;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.bootstrap.logger.BootstrapLogger;

public interface LibraryDetection {
    public boolean evaluatePresence(BootstrapLogger var1);

    public static LibraryDetection enabled() {
        return l -> true;
    }

    public static LibraryDetection eitherOf(LibraryDetection first, final LibraryDetection other) {
        class EitherOf
        implements LibraryDetection {
            EitherOf() {
            }

            @Override
            public boolean evaluatePresence(BootstrapLogger logger) {
                return LibraryDetection.this.evaluatePresence(logger) || other.evaluatePresence(logger);
            }
        }
        return first.new EitherOf();
    }

    public static class ByClassResolution
    implements LibraryDetection {
        private final ProtectedLibrary protectedLibrary;

        public ByClassResolution(ProtectedLibrary protectedLibrary) {
            this.protectedLibrary = Objects.requireNonNull(protectedLibrary, "protectedLibrary");
        }

        @Override
        public boolean evaluatePresence(BootstrapLogger logger) {
            try {
                Class.forName(this.protectedLibrary.sampleClass());
                return true;
            }
            catch (ClassNotFoundException ex) {
                return false;
            }
        }
    }

    public static class ByClassLoaderScan
    implements LibraryDetection {
        private final ProtectedLibrary protectedLibrary;
        private final ClassLoader platformClassLoader;

        public ByClassLoaderScan(ProtectedLibrary protectedLibrary, ClassLoader platformClassLoader) {
            this.protectedLibrary = Objects.requireNonNull(protectedLibrary, "protectedLibrary");
            this.platformClassLoader = Objects.requireNonNull(platformClassLoader, "platformClassLoader");
        }

        @Override
        public boolean evaluatePresence(BootstrapLogger logger) {
            return this.protectedLibrary.detect(this.platformClassLoader, logger);
        }
    }

    public static class Slf4jPluginLoggerMethod
    implements LibraryDetection {
        private final Object plugin;

        public Slf4jPluginLoggerMethod(Object plugin) {
            this.plugin = Objects.requireNonNull(plugin, "plugin");
        }

        @Override
        public boolean evaluatePresence(BootstrapLogger logger) {
            Class<?> pluginClass = this.plugin.getClass();
            try {
                pluginClass.getMethod("getLogger", new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethod) {
                throw new IllegalStateException("Not a plugin: " + String.valueOf(this.plugin), noSuchMethod);
            }
            try {
                pluginClass.getMethod("getSLF4JLogger", new Class[0]);
                return true;
            }
            catch (NoSuchMethodException ignored) {
                return false;
            }
        }
    }
}

