/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap;

import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import space.arim.libertybans.bootstrap.PlatformId;

public record Payload<P>(P plugin, PlatformId platformId, Path pluginFolder, List<Object> attachments) {
    public static final Object NO_PLUGIN = new Object();

    public Payload {
        Objects.requireNonNull(plugin, "plugin");
        Objects.requireNonNull(platformId, "platformId");
        Objects.requireNonNull(pluginFolder, "pluginFolder");
        attachments = List.copyOf(attachments);
    }

    public Payload(P plugin, PlatformId platformId, Path pluginFolder) {
        this(plugin, platformId, pluginFolder, List.of());
    }

    public <A> A getAttachment(int index, Class<A> attachmentType) {
        if (index > this.attachments.size()) {
            throw new IllegalArgumentException("Attachment requested does not exist: " + index);
        }
        Object attachment = this.attachments.get(index);
        if (!attachmentType.isInstance(attachment)) {
            throw new IllegalArgumentException("Attachment " + index + " is not ot type " + String.valueOf(attachmentType) + "; received " + String.valueOf(attachment));
        }
        return attachmentType.cast(this.attachments.get(index));
    }
}

