/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import space.arim.libertybans.bootstrap.DependencyBundle;
import space.arim.libertybans.bootstrap.LibraryDetection;
import space.arim.libertybans.bootstrap.PlatformId;
import space.arim.libertybans.bootstrap.logger.BootstrapLogger;

public final class Platform {
    final Category category;
    final PlatformId platformId;
    private final BootstrapLogger logger;
    private final Map<DependencyBundle, LibraryDetection> libraryDetectionMap;
    private final LibraryDetection hikariCP;

    Platform(Category category, PlatformId platformId, BootstrapLogger logger, Map<DependencyBundle, LibraryDetection> libraryDetectionMap, LibraryDetection hikariCP) {
        this.category = category;
        this.platformId = Objects.requireNonNull(platformId, "platformId");
        this.logger = logger;
        this.libraryDetectionMap = libraryDetectionMap;
        this.hikariCP = hikariCP;
    }

    public boolean isBundleProvided(DependencyBundle bundle) {
        boolean provided;
        LibraryDetection detection = this.libraryDetectionMap.get((Object)bundle);
        boolean bl = provided = detection != null && detection.evaluatePresence(this.logger);
        if (provided) {
            this.logger.debug("Found provided dependency bundle: " + String.valueOf((Object)bundle));
        }
        return provided;
    }

    boolean hasHiddenHikariCP() {
        return this.hikariCP != null && this.hikariCP.evaluatePresence(this.logger);
    }

    public static PreBuilder builder(Category category) {
        return new PreBuilder(category);
    }

    public String toString() {
        return "Platform{" + String.valueOf(this.platformId) + "}";
    }

    public static Stream<Builder> allPossiblePlatforms(String platformName) {
        HashSet<Builder> platforms = new HashSet<Builder>();
        for (Category category : Category.values()) {
            int setting = 0;
            while (setting < 32) {
                int flags = setting++;
                platforms.add(Platform.builder(category).nameAndVersion(platformName, "0.0").kyoriAdventureSupport(l -> (flags & 1) != 0).slf4jSupport(l -> (flags & 2) != 0).caffeineProvided(l -> (flags & 4) != 0).jakartaProvided(l -> (flags & 8) != 0).snakeYamlProvided(l -> (flags & 0x10) != 0));
            }
        }
        return platforms.stream();
    }

    public static enum Category {
        BUKKIT,
        BUNGEECORD,
        SPONGE,
        VELOCITY,
        STANDALONE;


        String display() {
            String categoryName = this.name();
            return categoryName.charAt(0) + categoryName.substring(1).toLowerCase(Locale.ROOT);
        }
    }

    public static final class PreBuilder {
        private final Category category;

        PreBuilder(Category category) {
            this.category = Objects.requireNonNull(category, "category");
        }

        public Builder nameAndVersion(String platformName, String platformVersion) {
            return new Builder(this.category, platformName, platformVersion);
        }
    }

    public static final class Builder {
        private final Category category;
        private final String platformName;
        private final String platformVersion;
        private final Map<DependencyBundle, LibraryDetection> libraryDetectionMap = new EnumMap<DependencyBundle, LibraryDetection>(DependencyBundle.class);
        private LibraryDetection hikariCP;

        private Builder(Category category, String platformName, String platformVersion) {
            this.category = category;
            this.platformName = platformName;
            this.platformVersion = platformVersion;
        }

        public Builder slf4jSupport(LibraryDetection slf4j) {
            this.libraryDetectionMap.put(DependencyBundle.SLF4J, slf4j);
            return this;
        }

        public Builder kyoriAdventureSupport(LibraryDetection kyoriAdventure) {
            this.libraryDetectionMap.put(DependencyBundle.KYORI, kyoriAdventure);
            return this;
        }

        public Builder caffeineProvided(LibraryDetection caffeine) {
            this.libraryDetectionMap.put(DependencyBundle.CAFFEINE, caffeine);
            return this;
        }

        public Builder jakartaProvided(LibraryDetection jakarta) {
            this.libraryDetectionMap.put(DependencyBundle.JAKARTA, jakarta);
            return this;
        }

        public Builder snakeYamlProvided(LibraryDetection snakeYaml) {
            this.libraryDetectionMap.put(DependencyBundle.SNAKEYAML, snakeYaml);
            return this;
        }

        public Builder hiddenHikariCP(LibraryDetection hikariCP) {
            this.hikariCP = hikariCP;
            return this;
        }

        public Platform build(BootstrapLogger logger) {
            PlatformId platformId = this.category.name().equalsIgnoreCase(this.platformName) ? new PlatformId(this.platformName, this.platformVersion) : new PlatformId(this.platformName + " (" + this.category.display() + ")", this.platformVersion);
            return new Platform(this.category, platformId, logger, this.libraryDetectionMap, this.hikariCP);
        }
    }
}

