/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.classload;

import java.util.Objects;
import space.arim.libertybans.bootstrap.classload.ClassLoadGuard;

public final class GuardedClassLoader
extends ClassLoader {
    private static final ClassNotFoundException DOES_NOT_LOAD_CLASSES;
    private final ClassLoadGuard guard;

    public GuardedClassLoader(ClassLoader parent, ClassLoadGuard guard) {
        super(parent);
        this.guard = Objects.requireNonNull(guard);
    }

    @Override
    protected Class<?> loadClass(String className, boolean resolve) throws ClassNotFoundException {
        return this.guard.delegateLoadClass(className, resolve, (x$0, x$1) -> super.loadClass(x$0, x$1));
    }

    @Override
    protected Class<?> findClass(String className) throws ClassNotFoundException {
        throw DOES_NOT_LOAD_CLASSES;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{guard=" + String.valueOf(this.guard) + ", parent=" + String.valueOf(this.getParent()) + "}";
    }

    static {
        ClassLoader.registerAsParallelCapable();
        DOES_NOT_LOAD_CLASSES = new ClassNotFoundException(GuardedClassLoader.class.getName() + " does not itself load classes");
    }
}

