/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.classload;

import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.bootstrap.classload.ClassLoadGuard;

public final class LibraryProtection
implements ClassLoadGuard {
    private static final ClassNotFoundException FAILED_FILTER = new ClassNotFoundException("Class is filtered from the eyes of child classloaders");
    private final ProtectedLibrary[] protectedLibraries;
    private final ClassLoadGuard next;

    public LibraryProtection(Set<ProtectedLibrary> protectedLibraries, ClassLoadGuard next) {
        this.protectedLibraries = protectedLibraries.toArray(new ProtectedLibrary[0]);
        this.next = Objects.requireNonNull(next);
    }

    @Override
    public Class<?> delegateLoadClass(String className, boolean resolve, ClassLoadGuard.Destination destination) throws ClassNotFoundException {
        for (ProtectedLibrary protectedLibrary : this.protectedLibraries) {
            if (!className.startsWith(protectedLibrary.basePackage())) continue;
            throw FAILED_FILTER;
        }
        return this.next.delegateLoadClass(className, resolve, destination);
    }

    public String toString() {
        return "LibraryProtection{protectedLibraries=" + Arrays.toString((Object[])this.protectedLibraries) + ", next=" + String.valueOf(this.next) + "}";
    }
}

