/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.depend;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import space.arim.libertybans.bootstrap.depend.DownloadResult;

public final class Dependency {
    private final String groupId;
    private final String artifactId;
    private final String version;
    private final transient byte[] sha512hash;
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toLowerCase(Locale.ROOT).toCharArray();

    private Dependency(String groupId, String artifactId, String version, byte[] sha512hash) {
        this.groupId = Objects.requireNonNull(groupId, "groupId");
        this.artifactId = Objects.requireNonNull(artifactId, "artifactId");
        this.version = Objects.requireNonNull(version, "version");
        this.sha512hash = (byte[])sha512hash.clone();
    }

    public static Dependency of(String groupId, String artifactId, String version, String hexHash) {
        return new Dependency(groupId, artifactId, version, Dependency.hexStringToByteArray(hexHash.toLowerCase(Locale.ROOT)));
    }

    static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return String.valueOf(hexChars);
    }

    public String getFullName() {
        return this.groupId + "." + this.artifactId + "_" + this.version;
    }

    public String groupId() {
        return this.groupId;
    }

    public String artifactId() {
        return this.artifactId;
    }

    public String version() {
        return this.version;
    }

    public byte[] getSha512Hash() {
        return (byte[])this.sha512hash.clone();
    }

    public boolean matchesHash(byte[] otherSha512Hash) {
        return Arrays.equals(this.sha512hash, otherSha512Hash);
    }

    DownloadResult hashMismatchResult(byte[] actualHash) {
        return DownloadResult.hashMismatch0(this.sha512hash, actualHash);
    }

    public String toString() {
        return "Dependency [groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.artifactId.hashCode();
        result = 31 * result + this.groupId.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Dependency)) {
            return false;
        }
        Dependency other = (Dependency)object;
        return this.groupId.equals(other.groupId) && this.artifactId.equals(other.artifactId) && this.version.equals(other.version);
    }
}

