/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.depend;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import space.arim.libertybans.bootstrap.depend.Dependency;
import space.arim.libertybans.bootstrap.depend.DownloadResult;
import space.arim.libertybans.bootstrap.depend.Repository;

class DependencyDownload {
    private final Dependency dependency;
    private final Repository repository;
    private final Path outputJar;

    DependencyDownload(Dependency dependency, Repository repository, Path outputJar) {
        this.dependency = dependency;
        this.repository = repository;
        this.outputJar = outputJar;
    }

    DownloadResult download() {
        byte[] jarBytes;
        MessageDigest digest;
        URL url;
        try {
            url = this.repository.locateDependency(this.dependency);
        }
        catch (MalformedURLException ex) {
            return DownloadResult.exception(ex);
        }
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException ex) {
            return DownloadResult.exception(ex);
        }
        try (InputStream inputStream = url.openStream();
             DigestInputStream digestInputStream = new DigestInputStream(inputStream, digest);){
            jarBytes = digestInputStream.readAllBytes();
        }
        catch (IOException ex) {
            return DownloadResult.exception(ex);
        }
        byte[] actualHash = digest.digest();
        if (!this.dependency.matchesHash(actualHash)) {
            return this.dependency.hashMismatchResult(actualHash);
        }
        try (FileChannel fc = FileChannel.open(this.outputJar, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW);){
            fc.write(ByteBuffer.wrap(jarBytes));
        }
        catch (IOException ex) {
            return DownloadResult.exception(ex);
        }
        return DownloadResult.success(this.outputJar);
    }
}

