/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.bootstrap.depend;

import java.nio.file.Path;

public class DownloadResult {
    private final ResultType resultType;
    private final Path jarFile;
    private final byte[] expectedHash;
    private final byte[] actualHash;
    private final Exception ex;

    private DownloadResult(ResultType resultType, Path jarFile, byte[] expectedHash, byte[] actualHash, Exception ex) {
        this.resultType = resultType;
        this.jarFile = jarFile;
        this.expectedHash = expectedHash;
        this.actualHash = actualHash;
        this.ex = ex;
    }

    private DownloadResult(ResultType resultType, Path jarFile, Exception ex) {
        this(resultType, jarFile, null, null, ex);
    }

    public ResultType getResultType() {
        return this.resultType;
    }

    public Path getJarFile() {
        return this.jarFile;
    }

    public byte[] getExpectedHash() {
        return this.expectedHash == null ? null : (byte[])this.expectedHash.clone();
    }

    public byte[] getActualHash() {
        return this.actualHash == null ? null : (byte[])this.actualHash.clone();
    }

    public Exception getException() {
        return this.ex;
    }

    public static DownloadResult success(Path outputJar) {
        return new DownloadResult(ResultType.SUCCESS, outputJar, null);
    }

    public static DownloadResult hashMismatch(byte[] expected, byte[] actual) {
        return DownloadResult.hashMismatch0((byte[])expected.clone(), (byte[])actual.clone());
    }

    static DownloadResult hashMismatch0(byte[] expected, byte[] actual) {
        return new DownloadResult(ResultType.HASH_MISMATCH, null, expected, actual, null);
    }

    public static DownloadResult exception(Exception ex) {
        return new DownloadResult(ResultType.ERROR, null, ex);
    }

    public static enum ResultType {
        SUCCESS,
        HASH_MISMATCH,
        ERROR;

    }
}

