/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.bungee.plugin;

import java.lang.reflect.Field;
import java.util.Optional;
import java.util.logging.Logger;
import net.md_5.bungee.api.plugin.PluginDescription;
import space.arim.libertybans.bootstrap.CulpritFinder;

final class BungeeCulpritFinder
implements CulpritFinder {
    private final Logger logger;

    BungeeCulpritFinder(Logger logger) {
        this.logger = logger;
    }

    private PluginDescription getProvidingPluginDescription(Class<?> clazz) {
        Object description;
        Field descriptionField;
        ClassLoader pluginClassLoader = clazz.getClassLoader();
        try {
            descriptionField = pluginClassLoader.getClass().getDeclaredField("desc");
        }
        catch (NoSuchFieldException ex) {
            this.logger.warning("Update needed: It seems that plugin classloading has been modified");
            return null;
        }
        try {
            descriptionField.setAccessible(true);
        }
        catch (RuntimeException ignored) {
            return null;
        }
        try {
            description = descriptionField.get(pluginClassLoader);
        }
        catch (IllegalAccessException ex) {
            this.logger.warning("Could not access PluginClassLoader.desc field: " + ex.getMessage());
            return null;
        }
        if (description instanceof PluginDescription) {
            return (PluginDescription)description;
        }
        this.logger.warning("PluginClassLoader.desc field did not return a PluginDescription");
        return null;
    }

    @Override
    public Optional<String> findCulprit(Class<?> libraryClass) {
        PluginDescription description = this.getProvidingPluginDescription(libraryClass);
        if (description == null) {
            return Optional.empty();
        }
        return Optional.of(description.getName() + " " + description.getVersion());
    }
}

