/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.bungee.plugin;

import java.util.logging.Level;
import net.md_5.bungee.api.ProxyServer;
import net.md_5.bungee.api.plugin.Plugin;
import space.arim.libertybans.bootstrap.BaseFoundation;
import space.arim.libertybans.bootstrap.Instantiator;
import space.arim.libertybans.bootstrap.LibertyBansLauncher;
import space.arim.libertybans.bootstrap.LibraryDetection;
import space.arim.libertybans.bootstrap.Payload;
import space.arim.libertybans.bootstrap.Platform;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.bootstrap.logger.JulBootstrapLogger;
import space.arim.libertybans.env.bungee.plugin.BungeeCulpritFinder;

public final class BungeePlugin
extends Plugin {
    private BaseFoundation base;

    public synchronized void onEnable() {
        if (this.base != null) {
            throw new IllegalStateException("Plugin enabled twice?");
        }
        this.base = this.initialize();
    }

    public synchronized void onDisable() {
        BaseFoundation base = this.base;
        this.base = null;
        if (base == null) {
            this.getLogger().warning("LibertyBans wasn't launched; check your log for a startup error");
            return;
        }
        base.shutdown();
    }

    static Platform.Builder detectPlatform(Plugin plugin) {
        ProxyServer server = plugin.getProxy();
        return Platform.builder(Platform.Category.BUNGEECORD).nameAndVersion(server.getName(), server.getVersion()).slf4jSupport(LibraryDetection.eitherOf(new LibraryDetection.Slf4jPluginLoggerMethod(plugin), new LibraryDetection.ByClassLoaderScan(ProtectedLibrary.SLF4J_API, Plugin.class.getClassLoader()))).snakeYamlProvided(LibraryDetection.enabled());
    }

    private BaseFoundation initialize() {
        BaseFoundation base;
        LibertyBansLauncher launcher = new LibertyBansLauncher.Builder().folder(this.getDataFolder().toPath()).logger(new JulBootstrapLogger(this.getLogger())).platform(BungeePlugin.detectPlatform(this)).executor(cmd -> this.getProxy().getScheduler().runAsync((Plugin)this, cmd)).culpritFinder(new BungeeCulpritFinder(this.getLogger())).build();
        Payload<BungeePlugin> payload = launcher.getPayload(this);
        ClassLoader launchLoader = launcher.attemptLaunch().join();
        try {
            base = new Instantiator("space.arim.libertybans.env.bungee.BungeeLauncher", launchLoader).invoke(payload);
        }
        catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
            this.getLogger().log(Level.WARNING, "Failed to launch LibertyBans", ex);
            return null;
        }
        base.startup();
        return base;
    }
}

