/*
 * Decompiled with CFR 0.152.
 */
package space.arim.libertybans.env.sponge.plugin;

import com.google.inject.Inject;
import java.nio.file.Path;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.Logger;
import org.spongepowered.api.Game;
import org.spongepowered.api.Server;
import org.spongepowered.api.command.Command;
import org.spongepowered.api.config.ConfigDir;
import org.spongepowered.api.event.Listener;
import org.spongepowered.api.event.lifecycle.ConstructPluginEvent;
import org.spongepowered.api.event.lifecycle.ProvideServiceEvent;
import org.spongepowered.api.event.lifecycle.RefreshGameEvent;
import org.spongepowered.api.event.lifecycle.RegisterCommandEvent;
import org.spongepowered.api.event.lifecycle.StoppingEngineEvent;
import org.spongepowered.api.service.ban.BanService;
import org.spongepowered.plugin.PluginContainer;
import org.spongepowered.plugin.builtin.jvm.Plugin;
import space.arim.libertybans.bootstrap.BaseFoundation;
import space.arim.libertybans.bootstrap.Instantiator;
import space.arim.libertybans.bootstrap.LibertyBansLauncher;
import space.arim.libertybans.bootstrap.LibraryDetection;
import space.arim.libertybans.bootstrap.Payload;
import space.arim.libertybans.bootstrap.Platform;
import space.arim.libertybans.bootstrap.ProtectedLibrary;
import space.arim.libertybans.env.sponge.plugin.Log4jBootstrapLogger;
import space.arim.libertybans.env.sponge.plugin.PlatformAccess;
import space.arim.libertybans.env.sponge.plugin.SpongeCulpritFinder;
import space.arim.libertybans.env.sponge.plugin.SpongeVersion;

@Plugin(value="libertybans")
public final class SpongePlugin {
    private final PluginContainer plugin;
    private final Game game;
    private final Logger logger;
    private final Path folder;
    private CompletableFuture<BaseFoundation> initializationFuture;
    private BaseFoundation base;

    @Inject
    public SpongePlugin(PluginContainer plugin, Game game, Logger logger, @ConfigDir(sharedRoot=false) Path folder) {
        this.plugin = plugin;
        this.game = game;
        this.logger = logger;
        this.folder = folder;
    }

    @Listener
    public synchronized void onConstruct(ConstructPluginEvent event) {
        if (event.plugin().instance() != this) {
            return;
        }
        if (this.initializationFuture != null || this.base != null) {
            throw new IllegalStateException("Server initialised twice?");
        }
        this.initializationFuture = this.initialize();
    }

    private static PlatformAccess platformAccess(BaseFoundation base) {
        return (PlatformAccess)base.platformAccess();
    }

    @Listener
    public synchronized void onRegisterCommands(RegisterCommandEvent<Command.Raw> event) {
        if (this.initializationFuture != null) {
            try {
                this.base = this.initializationFuture.join();
            }
            finally {
                this.initializationFuture = null;
            }
        }
        if (this.base == null) {
            return;
        }
        Command.Raw command = SpongePlugin.platformAccess(this.base).commandHandler();
        event.register(this.plugin, (Object)command, "libertybans", new String[0]);
    }

    @Listener
    public synchronized void onServiceProvision(ProvideServiceEvent.EngineScoped<BanService> event) {
        if (this.base == null) {
            return;
        }
        this.base.startup();
        PlatformAccess platformAccess = SpongePlugin.platformAccess(this.base);
        if (platformAccess.registerBanService()) {
            event.suggest(platformAccess::banService);
        }
    }

    @Listener
    public synchronized void onReload(RefreshGameEvent event) {
        if (this.base == null) {
            this.logger.warn("LibertyBans never launched so it cannot reload.");
            return;
        }
        boolean restarted = this.base.fullRestart();
        if (!restarted) {
            this.logger.info("Not restarting because loading already in process");
        }
    }

    @Listener
    public synchronized void onStop(StoppingEngineEvent<Server> event) {
        BaseFoundation base = this.base;
        this.base = null;
        if (base == null) {
            this.logger.warn("LibertyBans wasn't launched; check your log for a startup error");
            return;
        }
        base.shutdown();
    }

    private CompletableFuture<BaseFoundation> initialize() {
        SpongeVersion spongeVersion = SpongeVersion.detectVersion(this.game.platform().minecraftVersion().dataVersion().orElse(0)).orElseGet(SpongeVersion::latestSupported);
        ClassLoader platformClassLoader = Game.class.getClassLoader();
        LibertyBansLauncher launcher = new LibertyBansLauncher.Builder().folder(this.folder).logger(new Log4jBootstrapLogger(this.logger)).platform(Platform.builder(Platform.Category.SPONGE).nameAndVersion("Sponge", spongeVersion.display()).slf4jSupport(new LibraryDetection.ByClassResolution(ProtectedLibrary.SLF4J_API)).kyoriAdventureSupport(LibraryDetection.enabled()).caffeineProvided(LibraryDetection.enabled()).snakeYamlProvided(new LibraryDetection.ByClassLoaderScan(ProtectedLibrary.SNAKEYAML, platformClassLoader)).hiddenHikariCP(new LibraryDetection.ByClassLoaderScan(ProtectedLibrary.HIKARICP, platformClassLoader))).executor((Executor)this.game.asyncScheduler().executor(this.plugin)).culpritFinder(new SpongeCulpritFinder(this.game)).build();
        Payload<PluginContainer> payload = launcher.getPayloadWith(this.plugin, List.of(spongeVersion));
        return launcher.attemptLaunch().thenApply(launchLoader -> {
            BaseFoundation base;
            try {
                base = new Instantiator("space.arim.libertybans.env.sponge.SpongeLauncher", (ClassLoader)launchLoader).invoke(payload, Game.class, this.game);
            }
            catch (IllegalArgumentException | ReflectiveOperationException | SecurityException ex) {
                this.logger.warn("Failed to launch LibertyBans", (Throwable)ex);
                return null;
            }
            return base;
        });
    }
}

