/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import space.arim.omnibus.defaultimpl.events.Listener;

class BakedListenerGroup {
    private final Set<Class<?>> eventClasses;
    private final Listener<?>[] listeners;

    BakedListenerGroup(Set<Class<?>> eventClasses, Listener<?>[] listeners) {
        this.eventClasses = Set.copyOf(eventClasses);
        this.listeners = listeners;
    }

    Set<Class<?>> eventClasses() {
        return this.eventClasses;
    }

    Listener<?>[] listeners() {
        return this.listeners;
    }

    public String toString() {
        return "BakedListenerGroup{eventClasses=" + this.eventClasses + ", listeners=" + Arrays.toString(this.listeners) + "}";
    }

    void debugTo(CharSequence indentPrefix, Appendable output) throws IOException {
        output.append('\n').append(indentPrefix).append("Event classes: ");
        for (Class<?> eventClass : this.eventClasses) {
            output.append('\n').append(indentPrefix).append("  - ").append(eventClass.getName());
        }
        output.append('\n').append(indentPrefix).append("Event listeners: ");
        for (Listener<?> listener : this.listeners) {
            output.append('\n').append(indentPrefix).append("  - ").append(listener.toString());
        }
    }
}

