/*
 * Decompiled with CFR 0.152.
 */
package space.arim.omnibus.defaultimpl.events;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;
import space.arim.omnibus.defaultimpl.events.BakedListenerGroup;
import space.arim.omnibus.defaultimpl.events.EventClassDebug;
import space.arim.omnibus.defaultimpl.events.EventFire;
import space.arim.omnibus.defaultimpl.events.HierarchyScan;
import space.arim.omnibus.defaultimpl.events.Listener;
import space.arim.omnibus.defaultimpl.events.SynchronousListener;
import space.arim.omnibus.events.AsyncEvent;
import space.arim.omnibus.events.EventBusDriver;
import space.arim.omnibus.events.RegisteredListener;
import space.arim.omnibus.util.ArraysUtil;

final class DefaultEventsDriver
implements EventBusDriver {
    private final ConcurrentMap<Class<?>, Listener<?>[]> eventListeners = new ConcurrentHashMap();
    private final ConcurrentMap<Class<?>, BakedListenerGroup> bakedListeners = new ConcurrentHashMap();

    DefaultEventsDriver() {
    }

    private static <E> Listener<E>[] createGenericArray(int size) {
        return new Listener[size];
    }

    private static <E> Listener<E>[] combineListeners(Listener<E>[] existingListeners, Listener<E>[] appendListeners) {
        int existingSize = existingListeners.length;
        if (existingSize == 0) {
            return appendListeners;
        }
        int requiredSize = existingSize + appendListeners.length;
        Listener<E>[] expanded = DefaultEventsDriver.createGenericArray(requiredSize);
        System.arraycopy(existingListeners, 0, expanded, 0, existingSize);
        System.arraycopy(appendListeners, 0, expanded, existingSize, appendListeners.length);
        return expanded;
    }

    private <E> BakedListenerGroup computeListenersFor(Class<?> eventClass) {
        Object[] listeners = DefaultEventsDriver.createGenericArray(0);
        Set<Class<?>> eventClasses = new HierarchyScan(eventClass).scan();
        for (Class<?> thisEventClass : eventClasses) {
            Listener[] fromThisEventClass = (Listener[])this.eventListeners.get(thisEventClass);
            if (fromThisEventClass == null) continue;
            listeners = DefaultEventsDriver.combineListeners(listeners, fromThisEventClass);
        }
        Arrays.sort(listeners);
        return new BakedListenerGroup(eventClasses, (Listener<?>[])listeners);
    }

    private void uncacheBaked(Class<?> eventClass) {
        this.bakedListeners.values().removeIf(listenerGroup -> listenerGroup.eventClasses().contains(eventClass));
    }

    private Listener<?>[] getListenersTo(Class<?> eventClass) {
        BakedListenerGroup listenerGroup = this.bakedListeners.computeIfAbsent(eventClass, this::computeListenersFor);
        return listenerGroup.listeners();
    }

    <E> Listener<E>[] getListenersTo(E event) {
        Listener<Class<?>>[] casted = this.getListenersTo((E)event.getClass());
        return casted;
    }

    <E> void registerListener(Listener<E> listener) {
        Class<E> eventClass = listener.getEventClass();
        this.eventListeners.compute(eventClass, (c, existingListeners) -> {
            if (existingListeners == null) {
                return new Listener[]{listener};
            }
            int insertionIndex = -(Arrays.binarySearch(existingListeners, listener) + 1);
            return ArraysUtil.expandAndInsert(existingListeners, listener, insertionIndex);
        });
        this.uncacheBaked(eventClass);
    }

    void unregisterListener(Listener<?> listener) {
        Class<?> eventClass = listener.getEventClass();
        this.eventListeners.computeIfPresent(eventClass, (c, existingListeners) -> {
            int removalIndex = Arrays.binarySearch(existingListeners, listener);
            if (removalIndex < 0) {
                return existingListeners;
            }
            Listener[] updated = ArraysUtil.contractAndRemove(existingListeners, removalIndex);
            if (updated.length == 0) {
                return null;
            }
            return updated;
        });
        this.uncacheBaked(eventClass);
    }

    @Override
    public void fireEvent(Object event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        if (event instanceof AsyncEvent) {
            throw new IllegalArgumentException("Cannot use #fireEvent with asynchronous capable events");
        }
        EventFire.callSyncListeners(this.getListenersTo(event), event);
    }

    @Override
    public <E> RegisteredListener registerListener(Class<E> eventClass, byte priority, Consumer<? super E> eventConsumer) {
        SynchronousListener<? super E> listener = new SynchronousListener<E>(eventClass, priority, eventConsumer);
        this.registerListener(listener);
        return listener;
    }

    @Override
    public int getRegisteredListenerCount(Class<?> eventClass) {
        return this.getListenersTo((Object)eventClass).length;
    }

    @Override
    public String debugRegisteredListeners(Class<?> eventClass) {
        StringBuilder output = new StringBuilder();
        try {
            this.debugRegisteredListeners(eventClass, output);
        }
        catch (IOException ex) {
            throw new UncheckedIOException("StringBuilder should not throw IOException", ex);
        }
        return output.toString();
    }

    @Override
    public void debugRegisteredListeners(Class<?> eventClass, Appendable output) throws IOException {
        new EventClassDebug(output, true, "").debugEventClass(eventClass, (Listener[])this.eventListeners.get(eventClass), (BakedListenerGroup)this.bakedListeners.get(eventClass));
    }

    @Override
    public void debugEntireDriverState(Appendable output) throws IOException {
        output.append("Entire state of ").append(this.toString());
        EventClassDebug eventClassDebug = new EventClassDebug(output, false, "  ");
        for (Map.Entry entry : this.eventListeners.entrySet()) {
            Class eventClass = (Class)entry.getKey();
            eventClassDebug.debugEventClass(eventClass, (Listener[])entry.getValue(), (BakedListenerGroup)this.bakedListeners.get(eventClass));
        }
        if (!eventClassDebug.wroteAnything()) {
            output.append('\n').append("(Empty)");
        }
    }
}

